
#include <cstring>

#include "string.hh"
#include "getdata.hh"


static inline char * skip_space(char * s) {
  while (*s == ' ' || *s == '\t') ++s;
  return s;
}

static inline char * next_space(char * s) {
  while (*s != ' ' && *s != '\t' && *s != '\0') ++s;
  return s;
}

bool getdata_pair(PspellGetLine & in, 
		  PspellString & key, 
		  PspellString & data)
{
  PspellString temp;
  char * s;
  do {
    if (!in.getline(temp)) return false;
    s = temp.mutable_data();
    char * cp = strchr(s, '#');
    if (cp != 0) *cp = '\0';
    s = skip_space(s);
  } while (*s == '\0');
  char * end = next_space(s);
  key.assign(s, end - s);
  s = skip_space(end);
  end = strchr(s, '\0') - 1;
  while (end > s && (*end == ' ' || *end == '\t')) --end; 
    // ^^ remove space at the end.
  data.assign(s, end - s + 1);
  return true;
}


bool PspellGetLineFromString::getline(PspellString & str) {
  if (in_str[0] == '\0') return false;
  const char * end = in_str;
  while (*end != delem && *end != '\0') ++end;
  str.assign(in_str, end - in_str);
  in_str = end;
  if (*in_str == delem) ++in_str;
  return true;
}

bool PspellGetLineFromStream::getline(PspellString & str) {
  str = "";
  int c;
  while (true) {
    c  = in->get();
    if (c == EOF || static_cast<char>(c) == delem) break;
    str += static_cast<char>(c);
  }
  if (!*in && str.size() == 0) return false;
  return true;
}
