#include "util.h"

util::util() {
}

// Convert two chars (HEX) to 8 bit ASCII
char
util::hexConvert(const char* input) {
  unsigned short int ascii = 0;
  
  for (i=0; i<2; i++) {
    switch (input[i]) {
      case '0': { ascii += (int) (0 * pow(16,1-i)); break; }
      case '1': { ascii += (int) (1 * pow(16,1-i)); break; }
      case '2': { ascii += (int) (2 * pow(16,1-i)); break; }
      case '3': { ascii += (int) (3 * pow(16,1-i)); break; }
      case '4': { ascii += (int) (4 * pow(16,1-i)); break; }
      case '5': { ascii += (int) (5 * pow(16,1-i)); break; }
      case '6': { ascii += (int) (6 * pow(16,1-i)); break; }
      case '7': { ascii += (int) (7 * pow(16,1-i)); break; }
      case '8': { ascii += (int) (8 * pow(16,1-i)); break; }
      case '9': { ascii += (int) (9 * pow(16,1-i)); break; }
      case 'A': { ascii += (int) (10 * pow(16,1-i)); break; }
      case 'B': { ascii += (int) (11 * pow(16,1-i)); break; }
      case 'C': { ascii += (int) (12 * pow(16,1-i)); break; }
      case 'D': { ascii += (int) (13 * pow(16,1-i)); break; }
      case 'E': { ascii += (int) (14 * pow(16,1-i)); break; }
      case 'F': { ascii += (int) (15 * pow(16,1-i)); break; }
    }
  }
  
  return(ascii);
}

// Convert a single INT to a CHAR
char
util::intToChar(int num) {
  switch (num) {
    case 1: return('1');
    case 2: return('2');
    case 3: return('3');
    case 4: return('4');
    case 5: return('5');
    case 6: return('6');
    case 7: return('7');
    case 8: return('8');
    case 9: return('9');
    default: return('0');
  }
}

// Convert INT to ASCII pointer
char*
util::intToASCII(int num) {
  char* ptr = numStr;
  
  numStr[0] = intToChar((int) num/10000);
  num %= 10000;
  numStr[1] = intToChar((int) num/1000);
  num %= 1000;
  numStr[2] = intToChar((int) num/100);
  num %= 100;
  numStr[3] = intToChar((int) num/10);
  num %= 10;
  numStr[4] = intToChar((int) num/1);
  numStr[5] = '\0';
  
  while (ptr[1] && (*ptr == '0'))
    ptr++;
  
  if (*ptr)
    return(ptr);
  else
    return("\0");
}

// Remove whitespaces before/after and replace 2 or more WSs with 1 
void
util::fixInput(char* &input) {
  if (input == '\0')
    return;
  
  char* start = input;
  char* end = &input[strlen(input)-1];
  
  while (isspace(*start))
    start++;
  
  if (*input == '\0')
    return;
  
  while (isspace(*end)) {
    *end = '\0';
    end--;
  }
  
  memmove(input, start, strlen(start)+1);
  
  for (; *start; start++)
    if (isspace(*start)) {
      end = start;
      while (isspace(*end))
	end++;
      end--;
      if (&start != &end)
	memmove(start, end, strlen(end)+1);
    }
}

// Create encrypted ASCII value separated by a ':'
void
util::encryptPassword(char*& passwd) {
  char* temp;
  
  if (passwd == '\0')
    return;
  
  temp = ptrAlloc->allocMem(4*strlen(passwd)+1);
  strcpy(temp, "");
  
  for (i=0; passwd[i]; i++) {
    // Rotate left 4 bits, input is unsigned char (0-255)
    passwd[i] = (passwd[i] << 4) | (passwd[i] >> (8-4));
    strcat(temp, intToASCII((unsigned char) passwd[i]));
    if (passwd[i+1])
      strcat(temp, ":");
  }
  
  ptrAlloc->freeMem(passwd);
  passwd = temp;
}

// Extract decrypted ASCII value separated by a ':'
void
util::decryptPassword(char*& ptr) {
  if (ptr == '\0')
    return;
  
  unsigned char* passwd = (unsigned char *) ptr;
  
  for(i=0, j=0; passwd[i]; i++) {
    passwd[j++] = atoi(&ptr[i++]);
    // Rotate left 4 bits, input is unsigned char (0-255)
    passwd[j-1] = (passwd[j-1] << 4) | (passwd[j-1] >> (8-4));
    
    while (isdigit(passwd[i]))
      i++;
    
    if (passwd[i] == '\0')
      break;
  }
  passwd[j] = '\0';
}

// Convert condition with 'yes' or 'no'
char*
util::boolToEnglish(int condition) {
  if (condition)
    return("yes");
  else
    return("no");
}

// Copy string, free memory if necessary
void
util::strCpy(char* &destStr, const char* srcStr) {
  if (destStr != '\0')
    ptrAlloc->freeMem(destStr);
  
  destStr = ptrAlloc->allocMem(strlen(srcStr)+1);
  
  strcpy(destStr, srcStr);
}

// Reallocate memory and concatenate strings
void
util::strCat(char* &destStr, const char* srcStr) {
  // strlen(srcStr) sometimes returns a too low value!? Why?
  //destStr = ptrAlloc->reallocMem(destStr, strlen(destStr)+strlen(srcStr)+1);
  destStr = ptrAlloc->reallocMem(destStr, strlen(destStr)+512+1);
  
  strcat(destStr, srcStr);
}

util::~util() {
}
