#include "help.h"

help::help() {
}

// Display usage if argc != 1
void
help::showUsage() {
  ptrDisplay->showText("\n\
Usage: prepop

After launching prepop, type 'help' or '?' to get help on available commands.

Description:
prepop is a simple \"online\" POP3 email client, very suitable for dialups and
other slow connections. It lets you read the text/plain part of your email
messages without having to download those big pesky attachments (over dialups
this can sometimes take a long time and during this time you often have no idea
on how much data is left to be transferred). With prepop you can also see the
size of all the messages when listing them. You can't reply to messages since
this was not what prepop was designed to do. prepop was not designed to be an
alternative to your current email client. It's more of a complementing email
client doing some of the things your ordinary email client should have handled
in the first place.

Send comments, suggestions, contributions and bugreports to:
  Anders Rundegren <pt96aru@hem.passagen.se>

prepop comes with ABSOLUTELY NO WARRANTY. It is distributed \"AS IS\".
This is free software, and you are welcome to redistribute it according to the
terms of the GNU General Public License version 2. This license can be found at
http://www.gnu.org.\n
");
}

// Display help that lists all commands
void
help::showHelp() {
  ptrDisplay->showText("\n[01;04mLocal Commands[0m\n");
  ptrDisplay->showText("help            ");
  ptrDisplay->showText("Display this helpmenu\n");
  ptrDisplay->showText("about           ");
  ptrDisplay->showText("Display the about box\n");
  ptrDisplay->showText("vars            ");
  ptrDisplay->showText("Show environment variables\n");
  ptrDisplay->showText("host [host]     ");
  ptrDisplay->showText("Set the POP3 host for the current bookmark\n");
  ptrDisplay->showText("port [port]     ");
  ptrDisplay->showText("Set the port for the current bookmark\n");
  ptrDisplay->showText("user [user]     ");
  ptrDisplay->showText("Set the user for the current bookmark\n");
  ptrDisplay->showText("prefs           ");
  ptrDisplay->showText("Enter the settings mode\n");
  ptrDisplay->showText("save            ");
  ptrDisplay->showText("Save settings to ~/.prepoprc\n");
  ptrDisplay->showText("load            ");
  ptrDisplay->showText("Load settings from ~/.prepoprc\n");
  ptrDisplay->showText("bshow           ");
  ptrDisplay->showText("Show all bookmarks in memory array\n");
  ptrDisplay->showText("bsave [n]       ");
  ptrDisplay->showText("Save current bookmark (prompt) to position [n]\n");
  ptrDisplay->showText("bload [n]       ");
  ptrDisplay->showText("Load bookmark in position [n]\n");
  ptrDisplay->showText("bdel [n]        ");
  ptrDisplay->showText("Delete bookmark in position [n]\n");
  ptrDisplay->showText("quit            ");
  ptrDisplay->showText("Quit\n\n");
  ptrDisplay->showText("[01;04mRemote Commands[0m\n");
  ptrDisplay->showText("login           ");
  ptrDisplay->showText("Login to POP3 server\n");
  ptrDisplay->showText("logout          ");
  ptrDisplay->showText("Logout of POP3 server\n");
  ptrDisplay->showText("stat            ");
  ptrDisplay->showText("Show status of messages (total number and size)\n");
  ptrDisplay->showText("slist [n,n-n]   ");
  ptrDisplay->showText("Short listing of specified message(s) on server\n");
  ptrDisplay->showText("list [n,n-n]    ");
  ptrDisplay->showText("Long listing of specified message(s) on server\n");
  ptrDisplay->showText("del [n,n-n]     ");
  ptrDisplay->showText("Delete specified message(s)\n");
  ptrDisplay->showText("read [n]        ");
  ptrDisplay->showText("Read message specified by [n]\n");
  ptrDisplay->showText("cmd [command]   ");
  ptrDisplay->showText("Send POP3 command (RFC 1939, 2449)\n\n");
}

// Display help to the settings mode
void
help::showSettingsHelp() {
  ptrDisplay->showText("\n[01;04mNavigation Commands[0m\n");
  ptrDisplay->showText("help            ");
  ptrDisplay->showText("Display this helpmenu\n");
  ptrDisplay->showText("save            ");
  ptrDisplay->showText("Save settings to ~/.prepoprc\n");
  ptrDisplay->showText("load            ");
  ptrDisplay->showText("Load settings from ~/.prepoprc\n");
  ptrDisplay->showText("show            ");
  ptrDisplay->showText("Display current settings\n");
  ptrDisplay->showText("exit            ");
  ptrDisplay->showText("Exit the settings mode \n\n");
  ptrDisplay->showText("[01;04mSettings Variables[0m\n");
  ptrDisplay->showText("autosave        ");
  ptrDisplay->showText("Toggles if settings should be saved when you quit prepop\n");
  ptrDisplay->showText("loginstart      ");
  ptrDisplay->showText("Toggles if prepop is to login to the default bookmark on start\n");
  ptrDisplay->showText("savepass        ");
  ptrDisplay->showText("Toggles if passwords should be saved to ~/.prepoprc file\n");
  ptrDisplay->showText("fromname        ");
  ptrDisplay->showText("Toggles if name or email address should be listed in from field\n");
  ptrDisplay->showText("headers         ");
  ptrDisplay->showText("Toggles if headers should be shown when reading mail\n");
  ptrDisplay->showText("header [n]      ");
  ptrDisplay->showText("Toggles visibility of header [n] when reading mail\n");
  ptrDisplay->showText("scrolldelay [n] ");
  ptrDisplay->showText("Scrolling delay (ms) when reading mail (0 disables)\n");
  ptrDisplay->showText("linesfetch [n]  ");
  ptrDisplay->showText("Number of lines for prepop to fetch when reading mail\n");
  ptrDisplay->showText("showsize        ");
  ptrDisplay->showText("Toggles the prefix to be used when displaying sizes\n\n");
}

// Display the about box
void
help::aboutBox() {
  ptrDisplay->showText("\nprepop v");
  ptrDisplay->showText(VERSION);
  ptrDisplay->showText(" (");
  ptrDisplay->showText(DATE);
  ptrDisplay->showText("), GNU readline lib v");
  ptrDisplay->showText(rl_library_version);
  ptrDisplay->showText("\n
Latest version can be found at:
  http://www.rundegren.com

Send comments, suggestions, contributions and bugreports to:
  Anders Rundegren <pt96aru@hem.passagen.se>

prepop comes with ABSOLUTELY NO WARRANTY. It is distributed \"AS IS\".
This is free software, and you are welcome to redistribute it according to the
terms of the GNU General Public License version 2. This license can be found at
http://www.gnu.org.\n
");
}

help::~help() {
}
