#include "display.h"

display::display() {
}

// Display error on STDERR
void
display::showError(const char* message) {
  cerr << "\nError: " << message << "\n\n";
}

// Display error on STDERR and exit program
void
display::showFatalError(const char* message) {
  cerr << "\nFATAL: " << message << "\n\n";
  
  exit(1);
}

// Display integers
void
display::showText(int number) {
  cout << number;
}

// Display text, "N/A" is shown if input is NULL
void
display::showText(const char* text) {
  if (text == NULL)
    cout << "N/A";
  else
    cout << text;
}

// Display text with width and just, "N/A" is shown if input is NULL
void
display::showText(const char* text, int width, const char* just) {
  char* ptrEnv = (char*) getenv("COLUMNS");  // FIX (getenv == NULL)
  
  if (ptrEnv != NULL)
    width = (int) width*atoi(ptrEnv)/100;
  
  if (strcmp(just, "left") == 0)
    cout.setf(ios::left);
  else if (strcmp(just, "right") == 0)
    cout.setf(ios::right);
  
  if (text == NULL) {
    cout.width(width);
    cout << "N/A";
    return;
  }
  
  if ((signed) strlen(text) > (width-FIELDSPACE)) {
    for (i=0; i<(width-FIELDSPACE); i++)
      cout << text[i];
  }
  else {
    cout.width(width-FIELDSPACE);
    cout << text;
  }
  for (i=0; i<FIELDSPACE; i++)
    cout << " ";
}

// Display integer with width and justification
void
display::showText(int num, int width, const char* just) {
  char* ptrEnv = (char*) getenv("COLUMNS");  // FIX (getenv == NULL)
  
  if (ptrEnv != NULL)
    width = (int) width*atoi(ptrEnv)/100;
  
  if (strcmp(just, "left") == 0)
    cout.setf(ios::left);
  else if (strcmp(just, "right") == 0)
    cout.setf(ios::right);
  
  cout.width(width-FIELDSPACE);
  cout << num;
  
  for (i=0; i<FIELDSPACE; i++)
    cout << " ";
}

void
display::showScroll(const char* text, int delay) {
  cout << " 0%: " << flush;
  
  for (i=0; text[i]; i++) {
    
    cout << text[i] << flush;
    
    if (text[i] == '\n') {
      if (((int) 100*i/strlen(text)) < 10)
	cout << " " << flush;
      cout << (int) 100*i/strlen(text) << "%: " << flush;
    }
    
    usleep(1000*delay);
  }
}

display::~display() {
}
