#include "base64.h"

base64::base64()
{
}

// Display the bits in a byte
void
base64::dispBits(unsigned byte) {
  register unsigned short int bit;
  
  for (bit=128; bit>0; bit=bit/2) {
    if (byte & bit)
      cout << "1 ";
    else
      cout << "0 ";
    }
  cout << "\n";
}

// The base64 convert table
inline void
base64::convertTable(char &in) {
  switch (in) {
    case 'A': { in = 0; return; }
    case 'B': { in = 1; return; }
    case 'C': { in = 2; return; }
    case 'D': { in = 3; return; }
    case 'E': { in = 4; return; }
    case 'F': { in = 5; return; }
    case 'G': { in = 6; return; }
    case 'H': { in = 7; return; }
    case 'I': { in = 8; return; }
    case 'J': { in = 9; return; }
    case 'K': { in = 10; return; }
    case 'L': { in = 11; return; }
    case 'M': { in = 12; return; }
    case 'N': { in = 13; return; }
    case 'O': { in = 14; return; }
    case 'P': { in = 15; return; }
    case 'Q': { in = 16; return; }
    case 'R': { in = 17; return; }
    case 'S': { in = 18; return; }
    case 'T': { in = 19; return; }
    case 'U': { in = 20; return; }
    case 'V': { in = 21; return; }
    case 'W': { in = 22; return; }
    case 'X': { in = 23; return; }
    case 'Y': { in = 24; return; }
    case 'Z': { in = 25; return; }
    case 'a': { in = 26; return; }
    case 'b': { in = 27; return; }
    case 'c': { in = 28; return; }
    case 'd': { in = 29; return; }
    case 'e': { in = 30; return; }
    case 'f': { in = 31; return; }
    case 'g': { in = 32; return; }
    case 'h': { in = 33; return; }
    case 'i': { in = 34; return; }
    case 'j': { in = 35; return; }
    case 'k': { in = 36; return; }
    case 'l': { in = 37; return; }
    case 'm': { in = 38; return; }
    case 'n': { in = 39; return; }
    case 'o': { in = 40; return; }
    case 'p': { in = 41; return; }
    case 'q': { in = 42; return; }
    case 'r': { in = 43; return; }
    case 's': { in = 44; return; }
    case 't': { in = 45; return; }
    case 'u': { in = 46; return; }
    case 'v': { in = 47; return; }
    case 'w': { in = 48; return; }
    case 'x': { in = 49; return; }
    case 'y': { in = 50; return; }
    case 'z': { in = 51; return; }
    case '0': { in = 52; return; }
    case '1': { in = 53; return; }
    case '2': { in = 54; return; }
    case '3': { in = 55; return; }
    case '4': { in = 56; return; }
    case '5': { in = 57; return; }
    case '6': { in = 58; return; }
    case '7': { in = 59; return; }
    case '8': { in = 60; return; }
    case '9': { in = 61; return; }
    case '+': { in = 62; return; }
    case '/': { in = 63; return; }
    default: { in = -1; return; }
  }
}

// Decode the first octet
inline void
base64::decodeFirst(char* encoded, char &byte) {
  byte = (char) 255;
  
  if (!(32 & encoded[0])) byte = byte & 127;  // 8th bit (MSB)
  if (!(16 & encoded[0])) byte = byte & 191;  // 7th bit
  if (!(8 & encoded[0])) byte = byte & 223;   // 6th bit
  if (!(4 & encoded[0])) byte = byte & 239;   // 5th bit
  if (!(2 & encoded[0])) byte = byte & 247;   // 4th bit
  if (!(1 & encoded[0])) byte = byte & 251;   // 3rd bit
  if (!(32 & encoded[1])) byte = byte & 253;  // 2nd bit
  if (!(16 & encoded[1])) byte = byte & 254;  // 1st bit (LSB)
}

// Decode the second octet
inline void
base64::decodeSecond(char* encoded, char &byte) {
  byte = (char) 255;
  
  if (!(8 & encoded[1])) byte = byte & 127;
  if (!(4 & encoded[1])) byte = byte & 191;
  if (!(2 & encoded[1])) byte = byte & 223;
  if (!(1 & encoded[1])) byte = byte & 239;
  if (!(32 & encoded[2])) byte = byte & 247;
  if (!(16 & encoded[2])) byte = byte & 251;
  if (!(8 & encoded[2])) byte = byte & 253;
  if (!(4 & encoded[2])) byte = byte & 254;
}

// Decode the third octet
inline void
base64::decodeThird(char* encoded, char &byte) {
  byte = (char) 255;
  
  if (!(2 & encoded[2])) byte = byte & 127;
  if (!(1 & encoded[2])) byte = byte & 191;
  if (!(32 & encoded[3])) byte = byte & 223;
  if (!(16 & encoded[3])) byte = byte & 239;
  if (!(8 & encoded[3])) byte = byte & 247;
  if (!(4 & encoded[3])) byte = byte & 251;
  if (!(2 & encoded[3])) byte = byte & 253;
  if (!(1 & encoded[3])) byte = byte & 254;
}

// The base64 decoder function, decodes one row at a time
unsigned short int
base64::decodeBase(char* encoded, char* decoded) {
  register unsigned short int i = 0;
  
  // Encoded input must come in pair of 4s -> 3 octets
  for (; strlen(encoded) > 3; encoded += 4) {
    //cout << encoded[0] << encoded[1] << encoded[2] << encoded[3] << "\n";
    
    convertTable(encoded[0]);
    convertTable(encoded[1]);
    convertTable(encoded[2]);
    convertTable(encoded[3]);
    
    //dispBits(encoded[0]); dispBits(encoded[1]);
    //dispBits(encoded[2]); dispBits(encoded[3]);
    
    decodeFirst(encoded, decoded[i++]);
    decodeSecond(encoded, decoded[i++]);
    decodeThird(encoded, decoded[i++]);
    
    //cout << "\n" << decoded[0] << decoded[1] << decoded[2] << "\n";
    //dispBits(decoded[0]); dispBits(decoded[1]); dispBits(decoded[2]);
    //cout << "--END\n\n";
  }
  
  // Decrease if padding is done at end, can be one or two '=' chars
  if ((int) encoded[-2] < 0)
    i--;
  if ((int) encoded[-1] < 0)
    i--;
  
  return(i);
}

base64::~base64()
{
}
