/************************************************************************/
/*                                                                      */
/* Sentry - Port Scan Detector IO Library Include File                  */
/*                                                                      */
/* Author: Craig H. Rowland <crowland@psionic.com>                      */
/*                          <crowland@bipolar.net>                      */
/* Created: 10-12-97                                                    */
/* Modified: 03-04-99                                                   */
/*                                                                      */
/* Send all changes/modifications/bugfixes to the above addresses.      */
/*                                                                      */
/*                                                                      */
/* This software is Copyright(c) 1997-99 Craig H. Rowland               */
/*                                                                      */
/* Disclaimer:                                                          */
/*                                                                      */
/* All software distributed by Craig H. Rowland ("the author") and      */
/* Psionic Systems is distributed AS IS and carries NO WARRANTY or      */
/* GUARANTEE OF ANY KIND. End users of the software acknowledge that    */
/* they will not hold the author, Psionic Systems, and any employer of  */
/* the author liable for failure or non-function of a software          */
/* product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK                 */
/*                                                                      */
/* Licensing restrictions apply. See the license that came with this    */
/* file for more information or visit http://www.psionic.com for more   */
/* information.                                                         */
/*                                                                      */
/* $Id: portsentry_io.h,v 1.8 1999/08/04 04:41:36 crowland Exp crowland $ */
/************************************************************************/

/* prototypes */
int WriteBlocked (char *, char *, int, char *, char *, char *);
void Log (char *,...);
void Exit (int);
void Start (void);
int DaemonSeed (void);
int NeverBlock (char *, char *);
int CheckConfig (void);
int OpenTCPSocket (void);
int OpenUDPSocket (void);
#ifdef SUPPORT_STEALTH
	int OpenRAWTCPSocket (void);
	int OpenRAWUDPSocket (void);
#endif
int BindSocket (int, struct sockaddr_in, struct sockaddr_in, int);
int KillRoute (char *, int, char *);
int KillHostsDeny (char *, int, char *);
int KillRunCmd (char *, int, char *);
int ConfigTokenRetrieve (char *, char *);
int IsBlocked (char *, char *);
int SubstString (const char *, const char *, const char *, char *);
int DoBlockUDP (void);
int DoBlockTCP (void);

