/************************************************************************/
/*                                                                      */
/* Sentry - Port Scan Detector Include File                             */
/*                                                                      */
/* Author: Craig H. Rowland <crowland@psionic.com>                      */
/*                          <crowland@bipolar.net>                      */
/* Created: 10-12-97                                                    */
/* Modified: 03-04-99                                                   */
/*                                                                      */
/* Send all changes/modifications/bugfixes to the above addresses.      */
/*                                                                      */
/*                                                                      */
/* This software is Copyright(c) 1997-99 Craig H. Rowland               */
/*                                                                      */
/* Disclaimer:                                                          */
/*                                                                      */
/* All software distributed by Craig H. Rowland ("the author") and      */
/* Psionic Systems is distributed AS IS and carries NO WARRANTY or      */
/* GUARANTEE OF ANY KIND. End users of the software acknowledge that    */
/* they will not hold the author, Psionic Systems, and any employer of  */
/* the author liable for failure or non-function of a software          */
/* product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK                 */
/*                                                                      */
/* Licensing restrictions apply. See the license that came with this    */
/* file for more information or visit http://www.psionic.com for more   */
/* information.                                                         */
/*                                                                      */
/* Id: $Id: portsentry.h,v 1.21 1999/11/09 02:19:55 crowland Exp crowland $ */
/************************************************************************/

#define VERSION "1.0"

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <netdb.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <stdarg.h>
#include <assert.h>
#include <sys/param.h>
#include <sys/types.h>
#ifndef _LINUX_C_LIB_VERSION
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#endif
#include <arpa/inet.h>

#include "portsentry_config.h"
#include "portsentry_io.h"
#include "portsentry_util.h"

#ifdef SUPPORT_STEALTH
	#ifdef LINUX
		#include "portsentry_tcpip.h"
		#include <netinet/in_systm.h>
	#endif

#define TCPPACKETLEN 80
#define UDPPACKETLEN 68
#endif /* SUPPORT_STEALTH */

#ifdef NEXT
	#include <ansi.h>
#endif

#define ERROR -1
#define TRUE 1
#define FALSE 0
#define MAXBUF 1024
/* max size of an IP address plus NULL */
#define IPMAXBUF 16
/* max sockets we can open */
#define MAXSOCKS 64

/* Really is about 1025, but we don't need the length for our purposes */
#define DNSMAXBUF 255


/* prototypes */
int PortSentryModeTCP (void);
int PortSentryModeUDP (void);
int DisposeUDP (char *, int);
int DisposeTCP (char *, int);
int CheckStateEngine (char *);
int InitConfig(void);
void Usage (void);
int SmartVerifyTCP(struct sockaddr_in, struct sockaddr_in, int);
int SmartVerifyUDP(struct sockaddr_in, struct sockaddr_in, int);

#ifdef SUPPORT_STEALTH
int PortSentryStealthModeTCP (void);
int PortSentryAdvancedStealthModeTCP (void);
int PortSentryStealthModeUDP (void);
int PortSentryAdvancedStealthModeUDP (void);
char * ReportPacketType(struct tcphdr );
int PacketReadTCP(int, struct iphdr *, struct tcphdr *);
int PacketReadUDP(int, struct iphdr *, struct udphdr *);
#endif
