-- simple remote evaluation test

import HPL

data ServerMsg = Ping (Port ClientMsg)
	       deriving (Show, Read)
data ClientMsg = Pong String
	       deriving (Show, Read)

server :: IO ()
server  = do
  p <- newPort undefined
  "ping-pong" <<-> p
  reqs <- listenToPort p

  let pingServer []                     = return ()
      pingServer (Ping clientPort:reqs) = do
	name <- getEnv "HOST"
	clientPort <-- Pong name
	pingServer reqs

   pingServer reqs

main :: IO ()
main  = do
  initDistributedPorts Nothing [("server", server)]
  serverPort <- newPort undefined
  serverPort `named` "ping-pong"
  "enki" `hosts` "server"
  listened serverPort				-- wait until connected

  let timePing p = do
	putStr $ "Pinging " ++ show p ++ " ... "
	(name, ms) <- timeit $ pingPong p
	putStrLn $ "at " ++ name ++ " time=" ++ show ms ++ "ms"
      pingPong p = do
        clientPort <- newPort undefined
	answers <- listenToPort clientPort
	p <-- Ping clientPort
	let Pong name:_ = answers
	return name

  mapM_ timePing (replicate 4 serverPort)
  closePort serverPort	   -- to unregister it
