/*
 * Global POP daemon parameters.
 */

#ifndef _POP_PARAMS_H
#define _POP_PARAMS_H

/*
 * Are we going to be a standalone server, or start via an inetd clone?
 */
#define POP_STANDALONE			0

#if POP_STANDALONE

/*
 * The address and port to listen at.
 */
#define DAEMON_ADDR			"0.0.0.0"	/* INADDR_ANY */
#define DAEMON_PORT			110

/*
 * Limit the number of POP sessions we can handle at a time to reduce
 * the impact of connection flood DoS attacks.
 */
#define MAX_SESSIONS			50
#define MAX_SESSIONS_PER_SOURCE		5
#define MAX_BACKLOG			5
#define MIN_DELAY			10

#endif

/*
 * An unprivileged dummy user to run as before authentication. The user
 * and its UID must not be used for any other purpose.
 */
#define POP_USER			"popa3d"

/*
 * Sessions will be closed if idle for longer than POP_TIMEOUT seconds.
 * RFC 1939 says that "such a timer MUST be of at least 10 minutes'
 * duration", so I've made 10 minutes the default. In practice, you
 * may want to reduce this to, say, 2 minutes.
 */
#define POP_TIMEOUT			(10 * 60)

/*
 * Do we want to support the obsolete LAST command, as defined in RFC
 * 1460? It has been removed from the protocol in 1994 by RFC 1725,
 * and isn't even mentioned in RFC 1939. Still, some software doesn't
 * work without it.
 */
#define POP_SUPPORT_LAST		1

/*
 * Introduce some sane limits on the mailbox size in order to prevent
 * a single huge mailbox from stopping the entire POP service.
 */
#define MAX_MAILBOX_MESSAGES		100000
#define MAX_MAILBOX_BYTES		100000000

/*
 * Do we have shadow passwords? (Not for *BSD.)
 * Note: password aging is not supported.
 */
#define AUTH_SHADOW			1

/*
 * A salt used to waste some CPU time on dummy crypt(3) calls and make
 * it harder (but still far from impossible, on most systems) to check
 * for valid usernames. Adjust it for your crypt(3).
 */
#define AUTH_DUMMY_SALT			"xx"

/*
 * Message to return to the client when authentication fails. You can
 * #undef this for no message.
 */
#define AUTH_FAILED_MESSAGE		"Authentication failed (bad password?)"

/*
 * Your mail spool directory. Note: only local (non-NFS) mode 775 mail
 * spools are currently supported.
 */
#define MAIL_SPOOL_PATH			"/var/spool/mail"

/*
 * How do we talk to syslogd? These should be fine for most systems.
 */
#define SYSLOG_IDENT			"popa3d"
#define SYSLOG_OPTIONS			LOG_PID
#define SYSLOG_FACILITY			LOG_DAEMON
#define SYSLOG_PRIORITY			LOG_NOTICE

/*
 * There's probably no reason to touch anything below this comment.
 */

/*
 * According to RFC 1939: "Keywords and arguments are each separated by
 * a single SPACE character. Keywords are three or four characters long.
 * Each argument may be up to 40 characters long." We're only processing
 * up to two arguments, so it is safe to truncate after this length.
 */
#define POP_BUFFER_SIZE			0x80

/*
 * There's no reason to change this one either. Making this larger would
 * waste memory, and smaller values could make the authentication fail.
 */
#define AUTH_BUFFER_SIZE		(2 * POP_BUFFER_SIZE)

/*
 * File buffer sizes to use while parsing the mailbox and retrieving a
 * message, respectively. Can be changed.
 */
#define FILE_BUFFER_SIZE		0x10000
#define RETR_BUFFER_SIZE		0x8000

/*
 * The mailbox parsing code isn't allowed to truncate lines earlier than
 * this length. Keep this at least as large as the longest header field
 * name we need to check for, but not too large for performance reasons.
 */
#define LINE_BUFFER_SIZE		0x20

#endif
