/*
 * Miscellaneous syscall wrappers. See misc.h for the descriptions.
 */

#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/file.h>

int sleep_select(int sec, int usec)
{
	struct timeval timeout;

	timeout.tv_sec = sec;
	timeout.tv_usec = usec;

	return select(0, NULL, NULL, NULL, &timeout);
}

int flock_loop(int fd)
{
	while (flock(fd, LOCK_EX)) {
		if (errno != EBUSY) return -1;
		sleep_select(1, 0);
	}

	return 0;
}

int write_loop(int fd, char *buffer, int count)
{
	int offset, block;

	offset = 0;
	while (count > 0) {
		block = write(fd, &buffer[offset], count);

/* If any write(2) fails, we consider that the entire write_loop() has
 * failed to do its job. We don't even ignore EINTR here. We also don't
 * retry when a write(2) returns zero, as we could start eating up the
 * CPU if we did. */
		if (block < 0) return block;
		if (!block) return offset;

		offset += block;
		count -= block;
	}

/* Should be equal to the requested size, unless our kernel got crazy. */
	return offset;
}
