/*
	in.pop3gwd, a POP3 proxy
	Copyright (C) 1997 Andrea Borgia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "pop3-gw.h"

static char rcsid[] = "$Id: main.c,v 1.2 1997/06/19 09:03:41 root Exp $";


void main(int argc, char *argv[]) {
	/* default proxy identification and setup */
	char delimiter = '#';			/* needed to parse username and hostname */
	int timeout = 120;			/* timeout is 2 minutes */
	int remote_port = 110;			/* default POP3 port */
	
	/* POP3 commands and responses */
	char terminator[] = "\r\n";		/* responses are CRLF terminated */
	const char pos_reply[] = "+OK";		/* positive success indicator */
	const char neg_reply[] = "-ERR";	/* negative success indicator */
	const char user_cmd[] = "USER";		/* user identification command */
	const char quit_cmd[] = "QUIT";		/* quit session command */

	char log_ident[MAX_IO_LEN];		/* name of program (goes in the log) */
	char server_name[MAXHOSTNAMELEN];
	int count;
	char username[MAX_IO_LEN], hostname[MAX_IO_LEN];
	char output[MAX_IO_LEN];
	int connected = TRUE;
	int logged_in = FALSE;
	int in_bytes = 0;
	int out_bytes = 0;
	int remote_filedes;


	/* parse command-line parameters: program name, delimiter, timeout and port no. */
	parse_cmd_line(argc, argv, log_ident, MAX_IO_LEN, &delimiter, &timeout, &remote_port);

	/* start logging asap */
	openlog(log_ident, LOG_OPT, LOG_OWNER);
#ifdef DEBUG
	syslog(LOG_PRIO, "signing on ( $Revision: 1.2 $ )");
	syslog(LOG_PRIO, "delimiter: '%c' ; timeout: %ds ; port: %d", delimiter, timeout, remote_port);
#endif

	/* set server's hostname and setup greeting */
	if (gethostname(server_name, MAXHOSTNAMELEN) != 0)
		strncpy(server_name, "localhost", MAXHOSTNAMELEN);
	snprintf(output, MAX_IO_LEN, "%s %s %s %s%s", pos_reply, server_name, 
		GREETING, "ready", terminator);

	/* send POP greeting to user */
	if ((count = writen(STDOUT_FILENO, output, strlen(output), timeout)) == strlen(output))
		out_bytes += count;
	else
		connected = FALSE;
		
	/* read command and try to connect to remote POP server */
	while (connected == TRUE && logged_in == FALSE) {
		connected = get_remote_data(STDIN_FILENO, username, hostname, MAX_IO_LEN, timeout, terminator, delimiter, user_cmd, quit_cmd, pos_reply, neg_reply, &in_bytes, &out_bytes);
		if (connected == TRUE)
			logged_in = connect_login(STDIN_FILENO, &remote_filedes, MAX_IO_LEN, timeout, username, hostname, remote_port, terminator, pos_reply, neg_reply, user_cmd, &connected, &in_bytes, &out_bytes);
	}

#ifdef DEBUG
	if (logged_in)
		syslog(LOG_PRIO, "online to %s as %s", hostname, username);
#endif

	/* transparently pass data back and forth till either end terminates */
	if (connected == TRUE && logged_in == TRUE)
		relay_data(STDIN_FILENO, remote_filedes, timeout, &in_bytes, &out_bytes);

	syslog(LOG_PRIO, "signing off (in: %d bytes, out: %d bytes)", in_bytes, out_bytes);
	closelog();
}

