/*
 Multiply two 32-bit numbers, V1 and V2, using 32-bit
 arithmetic, to produce a 64 bit result in the HI/LO words.

          A B
        x C D
       ------
      AD || BD
AC || CB || 0

 where A and B are the high and low 16-bit words of V1,
 C and D are the 16-bit words of V2, AD is the product of
 A and D, and X || Y is (X << 16) + Y.
*/

void png_64bit_product (unsigned long v1, unsigned long v2,
  unsigned long *hi_product, unsigned long *lo_product)
{
 int a, b, c, d;
 unsigned long lo, hi, x, y;

 a = (v1 >> 16) & 0xffff;
 b = v1 & 0xffff;
 c = (v2 >> 16) & 0xffff;
 d = v2 & 0xffff;

 lo = b * d;                   /* BD */
 x = a * d + c * b;            /* AD + CB */
 y = ((lo >> 16) & 0xffff) + x;

 lo = (lo & 0xffff) | ((y & 0xffff) << 16);
 hi = (y >> 16) & 0xffff;

 hi += a * c;                  /* AC */

 *hi_product = hi;
 *lo_product = lo;
}
