/*
 *      PluSHS - Pluf Simple Hostname Scanner
 *      Copyright (C) 2001, 2002 pluf <pluf@wanadoo.es>
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * usage.c
 * 
 */
#include <stdio.h>
#include <stdlib.h>

#include "plushs.h"

void
usage(show_macros)
	int show_macros;
{       

	if (show_macros)
	        (void)printf("Macros:
(Valid macros for -f option)
  %%s  insert space         %%h  insert hostname
  %%n  insert newline       %%c  insert double quotes
  %%t  insert tab           %%T  insert total ip addresses
  %%i  insert ip address    %%d  exec program in background mode\n\n");
	else {

		(void)printf("\n%s", TITLE);
		(void)printf("
Usage: plushs [-acDhmTv] [-f format] [-l ip-file] [-o logfile]
              [-P plugin-id/ids] [-s pattern] [-t timeout] [-w wait]
              [-x patterns-file] ip-address or ip-address-range

Options:
    -a            Show hostname aliasses.
    -c            Turn off color.
    -D            Run in daemon mode.
    -f format     Execute <format> string when a match is found.
    -h            Print this help.
    -l <ip-file>  Scan ip address or ip addresses range from file <ip-file>.
    -m            Like -f option, for -l option.
    -o <logfile>  Logs output to <logfile>.
    -P <pid>      Run <pid> plugin for each ip address.
    -t <timeout>  Set timeout.
    -T            Use TCP for queries (UDP will be used by default).
    -v            Verbose mode.
    -w <wait>     Wait <wait> seconds between each hostname search.
    -s <pattern>  Search <pattern> in the hostname and output to a logfile.
    -x <patfile>  Extract patterns from file and output to a logfile.

<ip ranges> ejem: 192.168.1-255.1-255\n\n");
	}

	exit(0);
}
