/*
  soupreplay.c (C) 1996-1998 by Davide Barbieri <paci@pluto.linux.it>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "pconfig.h"
#include "video.h"
#include "soupread.h"
#include "util.h"
#include "main.h"

int Reply_Num=0;  /* none reply */

/* typedef struct mail_header_reply {
  char *to;
  char *subject;
  char *from;
  char *replyto;
  char *followupto;
  char *newsgroup;
  char *newsreader;
} mail_header_reply; */

/*typedef struct news_header_reply {
  char *From;
  char *Date;
  char *Newsgroups;
  char *Subject;
  char *MessageID;
  */
  /* optional headers, 1036rfc-compliant */
/* char *FollowupTo;
  char *Expires;
  char *ReplyTo;
  char *Sender;
  char *References;
  char *Control;
  char *Distribution;
  char *Keywords;
  char *Summary;
  char *Approved;
  char *Lines;
  char *Xref;
  char *Organization;
} news_header_reply; */

typedef struct group_reply {
  char* prefix;
  char* kind;
  char* encoding;
  int nreplies;
} group_reply;

group_reply info_reply[100]; /* 100 gruppi di risposte per ora */



/*
  This is used to generate a post, concatenating header
  file with body file
  */
unsigned long add_file(char *f1, char *f2, char encoding)
{
  char header[80];
  FILE *file1, *file2; 
  int c;
  unsigned long length;
  
  if ( ((file1=fopen(f1, "a"))==NULL) || ((file2=fopen(f2,"r"))==NULL) ) {
      fprintf (stderr,"Unable to open a file [%s] or [%s]!\n",f1,f2);
      return (0);
    }
  
  length=file_size(file2);
  sprintf (header, "#! rnews %ld\n", length);
  /*length += strlen(header);*/
  fprintf (file1,"%s",header);
  
  while ((c=fgetc(file2))!=EOF)
    fputc(c,file1);
  
  fclose(file1);
  fclose(file2);
  return(length);
}


/* edit(filename, header, include quote?) */
/* this function is used when editing a reply message */
/* I should work on it in order to include & quote only the */
/* body message, and not also the headers */
int edit_file(char* name, char* header, int quote)
{

  char temp[255];      /* call editor on body message */
  char temp2[255];     /* call editor on headers */
  char bufftmp[256];   /* buffer to read message to which we reply */
  char strtmp[10];     /* tmp string to know the lenght message */
  char choice, c;
  int end=0, i=0;
  int head_count=0;    /* to distinguish header from body */
  int byte_count=0;    /* count bytes read from message */
  int nbytes=0;        /* how much bytes have we to count? */
  FILE *fc;            /* file containg message to which we reply */
  FILE *fb;            /* file containg body reply message */
  FILE *fh;            /* file containg headers reply */
  FILE *reply_article; /* reply article itself */

  /* edit the body */
  sprintf (temp, "%s %s", EDITOR, "body");

  if (quote==1) { /* if the user want to quote the message text */
    
    if ( (fb=fopen("body", "w"))==NULL ) {
      printf ("Unable to open a file body!\n");
      return(-1);
    }
    
    if ( (fc=fopen(files[Curr_Conf], "r"))==NULL ) {
      printf ("Unable to open a file %s!\n", files[Curr_Conf]);
      return(-1);
    }
    
    
    fseek(fc, 0L, SEEK_SET);
    for (i=0; i < (mesg_array[Curr_Mesg-1].line); i++) fgets(bufftmp, 256, fc);
    
    strncpy(strtmp, bufftmp+9, 10);
    nbytes=atoi(strtmp);

    for (i=0; byte_count < nbytes ; i++){
      fgets(bufftmp, 256, fc);
      byte_count+=strlen(bufftmp);
      if (!strcmp(bufftmp,"\n") && head_count==0) {
        head_count=1;
        continue;
      }
      /* QUOTE is defined in pconfig.h */
      if (head_count==1)
        fprintf(fb, "%s %s", QUOTE, bufftmp); fflush(fb);
    }
    
    fclose(fb); 
    fclose(fc);
  } /* end quoting */
 
  /* edit the header */
  sprintf (temp2, "%s %s", EDITOR, "header");
 
  if ( (reply_article=fopen("reply.art", "w"))==NULL ) {
      printf ("Unable to open a file reply.art!\n");
      return(-1);
  }

  /* writing the header file */
  if ( (fh=fopen("header", "w"))==NULL ) {
      printf ("Unable to open a file header!\n");
      return(-1);
    }
  fprintf(fh, "%s", header);
  fclose(fh);


  system(temp); /* edit the file */
 
  while (!end){
    locate(1, ROWS-1);
    printf("P)ost, E)dit file H)eader edit or A)bandon: ");
    
    choice=getchar();
    switch(choice)
      {
      case 'p':
      case 'P':
        if ( (fb=fopen("body", "r"))==NULL ) {
          printf ("Unable to open a file body");
          exit(-1);
        }
        if ( (fh=fopen("header", "r"))==NULL ) {
          printf ("Unable to open a file header");
          exit(-1);
        }

        while ((c=fgetc(fh))!=EOF)
          fputc(c,reply_article);
        while ((c=fgetc(fb))!=EOF)
          fputc(c,reply_article);
        fclose(fh);
        fclose(fb);
        fclose(reply_article);
        add_file(name, "reply.art", 'u');
        /* rimuovi reply.art, header, e body */
        system("rm -f reply.art body header");
        
        info_reply[Curr_Conf].nreplies++;
        
	end = 1;
	break;
	
      case 'E':
      case 'e':
	system(temp);
	break;

      case 'H':
      case 'h':
	system(temp2);
	break;
	
      case 'a':
      case 'A':
	system("rm -f reply.art body header");
	end = 2;
      }
  }
  return( end-1 );
}


void SOUP_clear(char *file_list)
{
  char *file_list_rm;
  file_list_rm=calloc(strlen(file_list), sizeof(char));
  /* plor IS UNIX dipendent... */
  system(file_list); /* zip REPLY */
  strcat(file_list_rm, "rm -rf ");
  strcat(file_list_rm, file_list+14);
  system(file_list_rm); /* remove R000xxx.MSG files */
  system("rm -rf reply.art header body");
}


void SOUP_pack_replies()
{
  int i=0, nforum_replies=0;
  FILE *REPLIES;
  char *file_list;

  for (i=0; i<Last_Conf; i++)
    if (info_reply[i].nreplies>=1)
      nforum_replies++;

  
  if (nforum_replies==0) { /* if there is no replies ... */
    printf("\n No REPLIES...\n");
    return;
  }
  
  /* number of forum * 13 (lenght of R000xxx.MSG) plus
     20 (lenght of REPLY.zip REPLIES string) */
  file_list=calloc(nforum_replies*13+20, sizeof(char));
  
  strcat(file_list, COMPRESS);   
  strcat(file_list, " REPLY.zip REPLIES ");  

  if ( (REPLIES=fopen("REPLIES", "w"))==NULL ) {
          printf ("Unable to open file REPLIES");
          free(file_list);
          return;
  }


  for (i=0; i<Last_Conf; i++)
    if (info_reply[i].nreplies>=1) {
        fprintf(REPLIES, "%s\tnews\tun\t%d\n", info_reply[i].prefix, info_reply[i].nreplies);
	strcat(file_list, info_reply[i].prefix);
        strcat(file_list, ".MSG ");
    }

  fclose(REPLIES);

  SOUP_clear(file_list);
}


/* 0, Curr_Msg */
void SOUP_reply(int state, char type, int mesg) 
{
  int i=0;
  char filename_msg[255];
  char filename[252];
  char str[255];     /* to be used to scan the user input */
  char header[1000]; /* I don't know if 1000 is enough */

  filename_msg[0]='\0';
  filename[0]='\0';
  str[0]='\0';
  header[0]='\0';

  if ( state==-1 ) {      /* if it is not a reply to an existing mesg */
    
    cls();    

    if (type=='b') {      /* it is a Mail FIXME */
      locate(1,1);

      printf("To: "); 
      strcat(header, "To: "); 
      scanf("%s", str);
      strcat(header, str);
    }
    if (type=='u') {      /* it is a Post FIXME */
      locate(1,1);

      printf("Newsgroup: ");
      strcat(header, "Newsgroup: ");
      scanf("%s", str);
      strcat(header, str);
    }

    locate(1,2); 
    printf("Subject: ");
    strcat(header, "\nSubject: ");
    scanf("%s", str); 
    strcat(header, str);
    strcat(header, "\n\n");

    /* X-newsreader */
    strcat(header, "X-Newsreader: PLOR ");
    strcat(header, PROGNAME);
    strcat(header, " ");
    strcat(header, VERSION);
    strcat(header, "\n\n");
    
    sprintf(filename_msg,"R%s",files[Curr_Conf]);
    for (i=0; filename_msg[i]!='.'; i++) filename[i]=filename_msg[i];
    filename[i]='\0';
      
    /* Update info_reply of the Curr_Conf */
    info_reply[Curr_Conf].prefix=calloc(15, sizeof(char));
    info_reply[Curr_Conf].kind=calloc(5, sizeof(char));
    info_reply[Curr_Conf].encoding=calloc(3, sizeof(char));
    /* in REPLIES the name of the file are written
       without the extension. This is why I distinguish
       between filename and filename_msg */
    strcat(info_reply[Curr_Conf].prefix, filename);
    strcat(info_reply[Curr_Conf].kind, "news");
    strcat(info_reply[Curr_Conf].encoding, "un");
    
    edit_file(filename_msg, header, 0);
    
  }
  else { /* if IT IS a reply */
    cls();
    
    if (*encoding[Curr_Conf]=='u') { /* it is a news */
      /* header from, seems to be adjusted by uqwk, not by us */

      /* newsgroup header */
      strcat(header, "Newsgroups: ");
      strcat(header, area_name[Curr_Conf]);
      strcat(header, "\n");
    }
    if (*encoding[Curr_Conf]=='b') { /* it is a mail */

      strcat(header, "To: ");
      strcat(header, mesg_array[Curr_Mesg-1].from);
      strcat(header, "\n");
    }

      /* subject */
    strcat(header, "Subject: ");
    if ( strncmp(mesg_array[Curr_Mesg-1].subj, "Re: ", 4) )
      strcat(header, "Re: "); 
    strcat(header, mesg_array[Curr_Mesg-1].subj);
    
    /* References: */
    strcat(header, "References: ");
    strcat(header, mesg_array[Curr_Mesg-1].id);
    
    /* X-newsreader */
    strcat(header, "X-Newsreader: PLOR ");
    strcat(header, PROGNAME);
    strcat(header, " ");
    strcat(header, VERSION);
    strcat(header, "\n\n");
    
      
    sprintf(filename_msg, "R%s", files[Curr_Conf]);
    for (i=0; filename_msg[i]!='.'; i++) filename[i]=filename_msg[i];
    filename[i]='\0';
    
    /* Update info_reply of the Curr_Conf */
    info_reply[Curr_Conf].prefix=calloc(15, sizeof(char));
    info_reply[Curr_Conf].kind=calloc(5, sizeof(char));
    info_reply[Curr_Conf].encoding=calloc(3, sizeof(char));
    /* in REPLIES the name of the file are written
       without the extension. This is why I distinguish
       between filename and filename_msg */
    strcat(info_reply[Curr_Conf].prefix, filename);
    strcat(info_reply[Curr_Conf].kind, "news");
    strcat(info_reply[Curr_Conf].encoding, "un");
    
    edit_file(filename_msg, header, 1);
    
  } /* end if it is a news reply */
}

















