/* -*- Mode: Prolog -*- */
/** @copyright
  
  This file is part of PrologDoc (http://prologdoc.sourceforge.net/).

  Copyright (C) 2004 by Salvador Fandino (sfandino@@yahoo.com)

  PrologDoc is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  PrologDoc is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with PrologDoc; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  @/copyright */

:- module(pd_format, []).

:- use_module(library('prologdoc/pd_config')).

:- format_predicate('H', format_xml_quoted(_,_)).
:- format_predicate('C', format_config(_,_)).

xml_escape_chars([], []).
xml_escape_chars([C|T], E) :-
	xml_escape_char(C, E, E1),
	xml_escape_chars(T, E1).

xml_escape_char(C, E, E1) :-
	(   xml_escapes(C, S)
	->  append(S, E1, E)
	;   E=[C|E1] ).

xml_escapes(0'<, "&lt;").
xml_escapes(0'>, "&gt;").
xml_escapes(0'&, "&amp;").
xml_escapes(0'", "&quot;").       % work around for xemacs bug "').
xml_escapes(0'', "&#039;").
	
format_xml_quoted(_, T) :-
	sformat(P, '~w', [T]),
	atom_codes(P, C),
	xml_escape_chars(C, C1),
	atom_codes(P1, C1),
	write(P1).

format_config(_, C/Def) :-
	!,
	(   config(C, V)
	->  write(V)
	;   write(Def) ).
format_config(_, C) :-
	(   config(C, V)
	->  write(V)
	;   true ).