/* $Id: types.h 1242 2007-05-02 11:29:37Z bennylp $ */
/* 
 * Copyright (C) 2003-2007 Benny Prijono <benny@prijono.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */
#ifndef __PJLIB_UTIL_TYPES_H__
#define __PJLIB_UTIL_TYPES_H__

/**
 * @file types.h
 * @brief PJLIB-UTIL types.
 */

#include <pj/types.h>
#include <pjlib-util/config.h>

/**
 * @defgroup PJLIB_UTIL PJLIB-UTIL Library
 * @{
 */

PJ_BEGIN_DECL

/**
 * Initialize PJLIB UTIL (defined in errno.c)
 *
 * @return PJ_SUCCESS on success.
 */
PJ_DECL(pj_status_t) pjlib_util_init(void);



PJ_END_DECL


/**
 * @}
 */


/**
 * @mainpage PJLIB-UTIL
 *
 * \n
 * \n
 * \n
 * This is the documentation of PJLIB-UTIL, an auxiliary library providing
 * adjunct functions to PJLIB.
 * 
 * Please go to the <A HREF="modules.htm"><B>Modules</B></A> page for list
 * of modules.
 *
 *
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 * \n
 */

#endif	/* __PJLIB_UTIL_TYPES_H__ */

