/* Copyright (C) 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/

#include "common.h"
#include "cateditdlg.h"
#include "catnamedlg.h"

#include "cateditdlg.moc"

#include <qmessagebox.h>
#include <qtooltip.h>


CatEditDlg::CatEditDlg(QWidget *parent, char *name, 
                       CategoryAppInfo *pAppInfo, bool bConfirm) 
	  : QDialog(parent,name,TRUE,WStyle_Customize | WStyle_NormalBorder)
{
  setCaption("Edit categories");

  bConf = bConfirm;

  lbCat = new ListBox(this, "lbCat");

  qsCat0 = pAppInfo->name[0];

  for (int i=1; i<16; i++)
  {
    if (strlen(pAppInfo->name[i]) == 0)
      continue;
    lbCat->insertItem(pAppInfo->name[i]);
  }
  if (lbCat->count())
    lbCat->setSelected(0, TRUE);
  lbCat->setFont(QFont("fixed", 12));
  lbCat->setFocus();
  
  pbNew = new QPushButton("&Add", this, "pbNew");
  QToolTip::add(pbNew, "Create new category");
  connect(pbNew, SIGNAL(clicked()), this, SLOT(addCat()));

  pbDel = new QPushButton("&Delete", this, "pbDel");
  QToolTip::add(pbDel, "Delete selected category");
  connect(pbDel, SIGNAL(clicked()), this, SLOT(delCat()));
  
  pbChange = new QPushButton("&Change", this, "pbChange");
  QToolTip::add(pbChange, "Change selected category");
  connect(pbChange, SIGNAL(clicked()), this, SLOT(renCat()));

  pbCancel = new QPushButton("C&lose", this, "pbCancel");
  QToolTip::add(pbCancel, "Close dialog");
  connect(pbCancel, SIGNAL(clicked()), SLOT(reject()));

  QSize sz1, sz2, sz3, sz4;
  sz1 = pbNew   ->sizeHint();
  sz2 = pbDel   ->sizeHint();
  sz3 = pbChange->sizeHint();
  sz4 = pbCancel->sizeHint();

  int h1, h2, h3, h4, w1, w2, w3, w4, w, h;
  h1 = sz1.height();
  h2 = sz2.height();
  h3 = sz3.height();
  h4 = sz4.height();
  w1 = sz1.width();
  w2 = sz2.width();
  w3 = sz3.width();
  w4 = sz4.width();
    
  h = (h1 > h2) ? h1 : h2;
  h = (h3 > h ) ? h3 : h;
  h = (h4 > h ) ? h4 : h;
  w = (w1 > w2) ? w1 : w2;
  w = (w3 > w ) ? w3 : w;
  w = (w4 > w ) ? w4 : w;
    
  QSize sz(w, h);
  pbNew   ->resize(sz);
  pbDel   ->resize(sz);
  pbChange->resize(sz);
  pbCancel->resize(sz);

  lbCat->setGeometry(lMargin, tMargin, 
		     3*w+2*bttnMargin, 240);

  pbNew   ->setGeometry(lMargin, tMargin+lbCat->height()+bttnMargin,
                        pbNew->width(), pbNew->height());
  pbDel   ->setGeometry(pbNew->x()+pbNew->width()+bttnMargin, 
			tMargin+lbCat->height()+bttnMargin,
                        pbDel->width(), pbDel->height());
  pbChange->setGeometry(pbDel->x()+pbDel->width()+bttnMargin, 
			tMargin+lbCat->height()+bttnMargin,
                        pbChange->width(), pbChange->height());
  pbCancel->setGeometry(lMargin, pbNew->y()+pbNew->height()+bttnMargin,
                        pbCancel->width(), pbCancel->height());


  resize(lMargin+lbCat->width()+rMargin, 
         tMargin+lbCat->height() + bttnMargin + pbNew->height() + bttnMargin
         + pbCancel->height() + bMargin);

  setFixedSize(width(), height());
}


CatEditDlg::CatEditDlg()
  : QDialog(0,"",TRUE,WStyle_Customize | WStyle_NormalBorder)
{
  ;
}


CatEditDlg::~CatEditDlg()
{
  ;
}

void CatEditDlg::delCat()
{
  int idx=lbCat->currentItem();
  
  if ( (idx < 0) || (lbCat->count() == 0) )
    return;

  if (bConf)
    {
      QString s;
      s.sprintf("Do you really want to delete category <%s>?\n"
                "(Records which are assigned to this category\n"
                " will be moved to category <%s>)", 
		lbCat->text(idx), qsCat0.data());
      if (QMessageBox::warning(this, "Delete category", s.data(),
                       "Yes", "No", "Cancel", 1) != 0)
        return;
    }

  // emit signal with index of selected category (+1), 
  //   since first category is not displayed (and should not be deleted)
  emit(deleteCat(idx+1));

  // update listbox
  lbCat->removeItem(idx);
}

void CatEditDlg::renCat()
{
  int idx=lbCat->currentItem();
  if ( (idx < 0) || (lbCat->count() == 0) )
    return;
 
  QString s, t;
  s = lbCat->text(idx);

  CatNameDlg catnamedlg(this, "catnamedlg", s.data(), &t);
  if (catnamedlg.exec())
    {
      // check for duplicate category name!
      bool bDuplicate = FALSE;
      for (int i=0; i<lbCat->count(); i++) {
	if (stricmp(lbCat->text(i), t.data()) == 0)
	  bDuplicate = TRUE;
      }

      if (!bDuplicate) {
	lbCat->changeItem(t.data(), idx);
	emit(changeCat(idx+1, t.data()));
      }
      // FIXME: 
    }
}


void CatEditDlg::addCat()
{
  int idx=lbCat->count();
  if (idx >= 15)
    return;

  QString s, t;
  s = "";
  
  CatNameDlg catnamedlg(this, "catnamedlg", s.data(), &t);
  if (catnamedlg.exec())
    {
      // check for duplicate category name!
      bool bDuplicate = FALSE;
      for (int i=0; i<lbCat->count(); i++) {
	if (stricmp(lbCat->text(i), t.data()) == 0) {
	  bDuplicate = TRUE;
	}
      }

      if (!bDuplicate) {
	lbCat->insertItem(t.data());
	emit(newCat(idx, t.data()));
      }
    }
}



