/* Copyright (C) 1997, 1998, 1999 Michael Wiedmann

   This file is part of pi-address.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Additionally, you are granted permission to assume, for the purposes
   of distributing this program in object code or executable form
   under Section 3 of the GNU Public License, that the QT library 
   is normally distributed with the major components of the 
   operating system on which the executable or object code runs.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
   USA.

   Written by Michael Wiedmann <mw@miwie.in-berlin.de>
*/

#ifndef StatusBar_included
#define StatusBar_included

#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlist.h>
#include <qsize.h>
#include <qstring.h>

class StatusBar : public QFrame
{
    Q_OBJECT

public:

    StatusBar
    (
	int		wndHeight = 20,
	QWidget*	parent = NULL,
	const char*	name = NULL
    );
    

    virtual ~StatusBar();


    uint InsertTextRegion
    (
	int		stretch,
	const char*	text = NULL
    );
    // insert a text region in the status bar with relative size stretch and
    // optional text.  Return a number cooresponding to the text region

    void InsertSpacing
    (
	uint	width = 5
    );
    // insert some spacing between regions

    void SetText
    (
	uint		region,
	const QString&	text
    );
    // set the text in the given region

private: // attributes

    QList<QLabel>	itsLabelList;
    // list of labels

    QBoxLayout*		itsLayout;
    // layout for labels

    int			itsHeight;
};


inline void StatusBar::InsertSpacing
(
    uint	width
)
{
    itsLayout->addSpacing( width );
}


#endif // StatusBar_included
