#ifndef _CACHE_H_
#define _CACHE_H_

#include "config.h"

#ifdef HAVE_TREE_H
#include <sys/tree.h>
#else
#include "tree.h"
#endif
#include <sys/queue.h>


struct sc_ent {
        RB_ENTRY(sc_ent)    tlink;
	TAILQ_ENTRY(sc_ent) qlink;
	struct pf_addr      addr[2];
	double		    peak;
	double		    rate;
	time_t		    t;
	u_int32_t	    bytes;
        u_int16_t           port[2];
        u_int8_t            af;
        u_int8_t            proto;
};

int cache_init(int);
void cache_endupdate(void);
struct sc_ent *cache_state(struct pf_state *);
extern int cache_max, cache_size;


#endif
