/*	$OpenBSD: pfstat.h,v 1.1 2002/06/26 16:10:00 dhartmei Exp $ */

/*
 * Copyright (c) 2002, Daniel Hartmeier
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer. 
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef _PFSTAT_H_
#define _PFSTAT_H_

#define	DESC_SIZE	22

struct status {
	unsigned	 enabled;
	unsigned	 time;
	unsigned	 since;
	u_int64_t	 n[DESC_SIZE];
};

struct column {
	double		 v[DESC_SIZE];
};

struct graph {
	unsigned	 desc_nr;
	char		*label;
	u_int32_t	 color;	/* 0xRRGGBB00 */
	int		 filled;
	struct graph	*next;
};

struct matrix {
	char		*filename;
	unsigned	 beg, end;
	unsigned	 width, height;
	unsigned	 w0, h0, x0, y0;
	struct column	*columns;
	struct column	 max;
	struct graph	*graphs[2];
	struct matrix	*next;
};

struct descriptor_type {
	const char	*name;
	const char	*unit;
	const int	 cumulative;
	const int	 bytes;
};

extern int	 parse_config(const char *, struct matrix **);
extern int	 add_matrix(struct matrix **, const char *, unsigned,
		    unsigned, unsigned, unsigned);
extern int	 add_graph(struct graph **, const char *, const char *,
		    u_int32_t, int);

extern const struct descriptor_type descriptor[DESC_SIZE];

#endif /* _PFSTAT_H_ */
