
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#include "StrTools.h"
#include <stdio.h>


/* Trim string */
string cStrTools::Trim(const string& str)
{
	string::size_type iPosStart=0, iPosEnd=str.length() - 1;
	
	// Get first non-blank character
	for(; iPosStart<str.length() && ((str.at(iPosStart) == 0x20) || (str.at(iPosStart) == 0x09)); iPosStart++);
	
	if (iPosStart == str.length())
		return "";
		
		
	// Get last non-blank character
	for(; iPosEnd>iPosStart && ((str.at(iPosEnd) == 0x20) || (str.at(iPosEnd) == 0x09)); iPosEnd--);

	return str.substr(iPosStart, iPosEnd - iPosStart + 1); 
}


/* Retrieve tokens stored in string */
void cStrTools::GetTokens(const string& str, vector<string>& vectTokens, char separator/*=','*/)
{
	string::size_type iPosStart=0, iPosEnd=0;
	
	while ((iPosEnd != string::npos) && (iPosEnd < str.length()))
	{
		// Search delimiter
		iPosEnd=str.find(separator, iPosStart); 
		
		if (iPosEnd == string::npos)
			iPosEnd=str.length();

		// Get token
		string strToken(str, iPosStart, iPosEnd - iPosStart);

		// Trim it
		string strTrimmedToken=Trim(strToken);
		
		// We skip empty string
		if (!strTrimmedToken.empty())
			vectTokens.push_back(strTrimmedToken);	
	
		iPosStart=iPosEnd+1;
	}
}


/* Convert integer to string */
bool cStrTools::IntToString(int v, string& str)
{
#define BUFFER_SIZE 16

	char buffer[BUFFER_SIZE];
	if (snprintf(buffer, BUFFER_SIZE, "%u", v) >0 )
	{
		str=buffer;
		return true;
	}
	else
		return false;	

#undef BUFFER_SIZE
}


