
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#include "LogEntry.h"
#include <string.h>

#ifdef DEBUG_MODE
#include <iostream>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif


/* Default constructor */
cLogEntry::cLogEntry() : m_flags(cLogEntry::ENTRYDATA_NONE), m_time(), m_ifName(), m_ruleNumber(0), m_action(0), m_direction(0), m_protocol(0), m_destAddress(), m_srcAddress(), m_destPort(0), m_srcPort(0)
{
	bzero(&m_time, sizeof(m_time));
	bzero(&m_destAddress, sizeof(m_destAddress));
	bzero(&m_srcAddress, sizeof(m_srcAddress));
}


/* Reset object */
void cLogEntry::Reset()
{
	m_flags=cLogEntry::ENTRYDATA_NONE;
	bzero(&m_time, sizeof(m_time));
	m_ifName.erase();
	m_ruleNumber=0;
	m_action=0;
	m_direction=0;
	m_protocol=0;
	bzero(&m_destAddress, sizeof(m_destAddress));
	bzero(&m_srcAddress, sizeof(m_srcAddress));
	m_destPort=0;
	m_srcPort=0;
}


/* Dump */
#ifdef DEBUG_MODE
void cLogEntry::Dump() const
{
	cerr<<"Flags: 0x"<<hex<<m_flags<<dec<<endl;
	
	if ((m_flags & ENTRYDATA_PFLOG) == ENTRYDATA_PFLOG)
	{
		time_t t=m_time.tv_sec;
		cerr<<"- Date: "<<ctime(&t);
		cerr<<"- If name: "<<m_ifName<<endl;
		cerr<<"- Rule number: "<<m_ruleNumber<<endl;
		cerr<<"- Action: "<<(int)m_action<<endl;
		cerr<<"- Direction: "<<(int)m_direction<<endl;
	}

	if ((m_flags & ENTRYDATA_IP) == ENTRYDATA_IP)
	{
		cerr<<"- Protocol: "<<(int)m_protocol<<endl;
		cerr<<"- Source address: "<<inet_ntoa(m_srcAddress)<<endl;
		cerr<<"- Destination address: "<<inet_ntoa(m_destAddress)<<endl;
	}

	if ((m_flags & ENTRYDATA_TCP) == ENTRYDATA_TCP)
	{
		cerr<<"- TCP Source port: "<<m_srcPort<<endl;
		cerr<<"- TCP Destination port: "<<m_destPort<<endl;
	}

	if ((m_flags & ENTRYDATA_UDP) == ENTRYDATA_UDP)
	{
		cerr<<"- UDP Source port: "<<m_srcPort<<endl;
		cerr<<"- UDP Destination port: "<<m_destPort<<endl;
	}
}
#endif	
