
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#ifndef __LOGPARSER_H__
#define __LOGPARSER_H__

#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <net/pfvar.h>
#include <net/if_pflog.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <pcap.h>
#include <string>
#include <vector>

#include "LogEntry.h"

using namespace std;

class cLogParser
{
public:

	/* Constructor */
	cLogParser();

	/* Errors generated by ParsePacket() method */
	enum eParsePacketError
	{
		PACKET_NOERROR=0,
		PACKET_INVALID_LEN,
		PACKET_INVALID_PFLOG_HDRLEN,
		PACKET_INVALID_IPVERSION,
		PACKET_INVALID_IP_HDRLEN,
		PACKET_INVALID_TCP_HDRLEN,
		PACKET_INVALID_UDP_HDRLEN,
		PACKET_PARSER_INTERNAL_ERROR
	};
		
	/* Parse specified log file */
	bool ParseLog(const string& filename, vector<cLogEntry>& vectEntries, vector<pair<int, enum eParsePacketError> >& vectErrors);


	/* Get last libpcap error message */
	inline const string& GetPcapErrorMessage() const
	{
		return m_pcapError;
	}
	
	
	/* Get error message corresponding to a value of eParsePacketError enumeration */
	const string GetParsePacketErrorMessage(enum eParsePacketError e) const;

protected:

	/* Extract information from a packet */
	enum eParsePacketError ParsePacket(const struct pcap_pkthdr& pHeader, const u_char* pData, cLogEntry& entry);

	/* Feed an entry with information extracted from pflog, IP and TCP/UDP headers */
	bool FeedEntry(const struct pfloghdr* pfHeader, const struct ip* ipHeader, const struct tcphdr* tcpHeader, const struct udphdr* udpHeader, cLogEntry& entry);


	/* Last libpcap error message */
	string m_pcapError;
};

#endif // __LOGPARSER_H__
