
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#ifndef __LOGENTRYPARSER_H__
#define __LOGENTRYPARSER_H__

#include "LogEntry.h"
#include <string>

using namespace std;

class cLogEntryParser
{
public:

	/* Constructor */
	cLogEntryParser();
	
	
	/* Return values for ParseString() method */
	enum eParseStringRet
	{
		PARSESTRING_NO_ERROR=0,
		PARSESTRING_MISSING_IP_FIELDS,
		PARSESTRING_MISSING_PFLOG_FIELDS,
		PARSESTRING_MISSING_TCPUDP_FIELDS,
		PARSESTRING_TIME_ERROR,
		PARSESTRING_ACTION_ERROR,
		PARSESTRING_RULENUMBER_ERROR,
		PARSESTRING_DIRECTION_ERROR,
		PARSESTRING_PROTOCOL_ERROR,
		PARSESTRING_ADDRESSES_ERROR,
		PARSESTRING_PORTS_ERROR
	};
	
	/* Parse given strings */
	enum eParseStringRet ParseStrings(const string& time, const string& ifName, const string& ruleNumber, const string& action, const string& direction, const string& protocol, const string& destAddress, const string& srcAddress, const string& destPort, const string& srcPort);


	/* Get entry */
	inline const cLogEntry& GetEntry() const
	{
		return m_entry;
	} 
		
protected:

	/* Parse Pflog header strings */
	enum eParseStringRet ParsePflogStrings(const string& time, const string& ifName, const string& ruleNumber, const string& action, const string& direction, const string& protocol);

	/* Parse addresses strings */
	enum eParseStringRet ParseAddressesStrings(const string& destAddress, const string& srcAddress);

	/* Parse ports strings */
	enum eParseStringRet ParsePortsStrings(const string& destPort, const string& srcPort);


	/* Parse methods for fields */
	bool ParseTime(const string& time);
	bool ParseAction(const string& action);
	bool ParseRuleNumber(const string& ruleNumber);
	bool ParseDirection(const string& direction);
	bool ParseProtocol(const string& protocol);
	

	/* Reset object */
	void Reset();
		

	/* Entry */
	cLogEntry m_entry;
};

#endif // __LOGENTRYPARSER_H__
