
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 


#ifndef __LOGENTRY_H__
#define __LOGENTRY_H__

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <net/if.h>
#include <netinet/in.h>
#include <net/pfvar.h>
#include <string>

using namespace std;

class cLogEntry
{
public:

	/* Default constructor */
	cLogEntry();

	
	/* Flags for entry data */
	enum eEntryData
	{
		ENTRYDATA_NONE=0x0,
		ENTRYDATA_PFLOG=0x1,
		ENTRYDATA_IP=0x2,
		ENTRYDATA_TCP=0x4,
		ENTRYDATA_UDP=0x8
	};

	/* Get entry data flags */
	inline unsigned int GetEntryDataFlags() const
	{
		return m_flags;
	}

	/* Set entry data flags */
	inline void SetEntryDataFlags(unsigned int flags)
	{
		m_flags=flags;
	}

	
	/* Get capture time */
	inline const struct timeval& GetTime() const
	{
		return m_time;
	}

	/* Set capture time */
	inline void SetTime(long sec, long usec)
	{
		m_time.tv_sec=sec;
		m_time.tv_usec=usec;
	}


	/* Get interface name */
	inline const string& GetIfName() const
	{
		return m_ifName;
	}

	/* Set interface name */
	inline void SetIfName(const string& ifName)
	{
		m_ifName=ifName;
	}
	
	
	/* Get rule number */
	inline u_int32_t GetRuleNumber() const
	{
		return m_ruleNumber;	
	}
	
	/* Set rule number */
	inline void SetRuleNumber(u_int32_t ruleNumber)
	{
		m_ruleNumber=ruleNumber;
	}
	
	
	/* Get action */
	inline u_int8_t GetAction() const
	{
		return m_action;
	}
	
	/* Set action */
	inline void SetAction(u_int8_t action)
	{
		m_action=action;
	}
	
	
	/* Get direction */
	inline u_int8_t GetDirection() const
	{
		return m_direction;
	}
	
	/* Set direction */
	inline void SetDirection(u_int8_t direction)
	{
		m_direction=direction;
	}
	
	
	/* Get protocol */
	inline u_int8_t GetProtocol() const
	{
		return m_protocol;
	}

	/* Set protocol */
	inline void SetProtocol(u_int8_t protocol)
	{
		m_protocol=protocol;

	}
	
	
	/* Get destination address */
	inline const struct in_addr& GetDestAddress() const
	{
		return m_destAddress;
	}
	
	/* Set destination address */
	inline void SetDestAddress(const struct in_addr& destAddress)
	{
		m_destAddress=destAddress;
	}
	

	/* Get source address */
	inline const struct in_addr& GetSrcAddress() const
	{
		return m_srcAddress;
	}

	/* Set source address */
	inline void SetSrcAddress(const struct in_addr& srcAddress)
	{
		m_srcAddress=srcAddress;
	}
	

	/* Get destination port */
	inline u_int16_t GetDestPort() const
	{
		return m_destPort;
	}

	/* Set destination port */
	inline void SetDestPort(u_int16_t destPort)
	{
		m_destPort=destPort;
	}
	
	
	/* Get source port */
	inline u_int16_t GetSrcPort() const
	{
		return m_srcPort;
	}
	
	/* Set source port */
	inline void SetSrcPort(u_int16_t srcPort)
	{
		m_srcPort=srcPort;
	}


	/* Reset object */
	void Reset();

#ifdef DEBUG_MODE

	/* Dump */
	void Dump() const;
#endif	

protected:	

	/* Entry data flags */
	unsigned int m_flags;

	/* Capture time */
	struct timeval m_time;
	
	
	/* pflog packet header */

	/* Interface name */
	string m_ifName;
	
	/* Rule number */
	u_int32_t m_ruleNumber;
	
	/* Action */
	u_int8_t m_action;
	
	/* Direction */
	u_int8_t m_direction;
	

	/* IP packet header */
	
	/* Protocol */
	u_int8_t m_protocol;
	
	/* Source and destination addresses */
	struct in_addr m_destAddress, m_srcAddress;
	
	
	/* TCP / UDP packet header */
	
	/* Source and destination ports */
	u_int16_t m_destPort, m_srcPort;
};
	


#endif // __LOGENTRY_H__
