
/*
 * Copyright (c) 2005, Arnaud KLEIN
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */ 

 
#ifndef __CMDLINEPARSER_H__
#define __CMDLINEPARSER_H__

#include <map>
#include <string>
#include "Options.h"

using namespace std;

class cCmdLineParser
{
public:

	/* Constructor */
	cCmdLineParser(int argc, char** argv);

	/* Parse */
	enum eParseRet
	{
		PARSE_NO_ERROR=0,
		PARSE_ERROR,
		PARSE_HELP_DISPLAY,
		PARSE_VERSION_DISPLAY
	};
	
	enum eParseRet Parse();
	
	
	/* Get error string (use it when Parse() returns false) */
	inline const string& GetErrorString() const
	{
		return m_errorString;
	}
	
	
	/* Get options (use it when Parse() returns true) */
	inline const cOptions GetOptions() const
	{
		return m_options;
	}
	
	
	/* Initialize object */
	static void Initialize();

protected:

	/* Generate options string */
	string GenerateOptionsString() const;
	
	/* Parse argument of options */
	bool ParseArgInputFile(const string& argument);
	bool ParseArgOutputFile(const string& argument);
	bool ParseArgAction(const string& argument);
	bool ParseArgDirection(const string& argument);
	bool ParseArgProtocol(const string& argument);
	bool ParseArgInterface(const string& argument);
	bool ParseArgOutDateFormat(const string& argument);


	/* Parse a filter argument */
	bool ParseArgFilter(const string& argument, const map<string, u_int8_t>& mapArguments, int optopt, vector<u_int8_t>& vectFilter);

	
	/* Command line arguments */
	int m_argc;
	char** m_argv;
	
	/* Options */
	cOptions m_options;
	
	/* Error string */
	string m_errorString;
	
	
	/* Mapping between external and internal values for filters */
	static map<string, u_int8_t> s_mapArgAction, s_mapArgDirection, s_mapArgProtocol;
};

#endif // __CMDLINEPARSER_H__
