/* $Id: quickreference.c,v 1.8.2.3 2002/06/14 14:00:48 tm Exp $
 *
 * PDFlib/PDI client: mini imposition demo
 */
#include <stdio.h>
#include <stdlib.h>

#include "pdflib.h"

int
main(void)
{
    PDF *p;
    int manual, page;
    int font, row, col;
    const int maxrow = 2;
    const int maxcol = 2;
    int startpage = 132, endpage = 135;
    const float width = 500, height = 770;
    int pageno;
    const char *infile = "../../doc/PDFlib-manual.pdf";

    p = PDF_new();

    if (PDF_open_file(p, "quickreference.pdf") == -1) {
	fprintf(stderr, "Error: cannot open PDF file 'quick_reference.pdf'.\n");
	exit(2);
    }

    PDF_set_info(p, "Creator", "quickreference.c");
    PDF_set_info(p, "Author", "Thomas Merz");
    PDF_set_info(p, "Title", "mini imposition demo (C)");

    manual = PDF_open_pdi(p, infile, "", 0);
    if (manual == -1) {
	fprintf(stderr, "Couldn't open input file '%s'.\n", infile);
	exit(2);
    }

    row = 0;
    col = 0;

    for (pageno = startpage; pageno <= endpage; pageno++) {
	if (row == 0 && col == 0) {
	    PDF_begin_page(p, width, height);
	    font = PDF_findfont(p, "Helvetica-Bold", "host", 0);
	    PDF_setfont(p, font, 18);
	    PDF_set_text_pos(p, 25, height-24);
	    PDF_show(p, "PDFlib 4.0 Quick Reference");
	}

	page = PDF_open_pdi_page(p, manual, pageno, "");

	if (page == -1) {
	    fprintf(stderr, "Couldn't open page %d in '%s'.\n", pageno, infile);
	    exit(2);
	}

	PDF_place_pdi_page(p, page, width/maxcol*col, height - (row + 1) 
			* height/maxrow, (float) 1/maxrow, (float) 1/maxrow);
	PDF_close_pdi_page(p, page);

	col++;
	if (col == maxcol) {
	    col = 0;
	    row++;
	}
	if (row == maxrow) {
	    row = 0;
	    PDF_end_page(p);
	}
    }

    /* finish the last partial page */
    if (row != 0 || col != 0)
	PDF_end_page(p);

    PDF_close(p);
    PDF_close_pdi(p, manual);
    PDF_delete(p);

    return 0;
}
