// -*- c++ -*-
//
// $Id: TestRecord.h,v 1.5 2000/01/19 17:14:43 bmah Exp $
//
// TestRecord.h
// Bruce A. Mah <bmah@ca.sandia.gov>
//
// This work was first produced by an employee of Sandia National
// Laboratories under a contract with the U.S. Department of Energy.
// Sandia National Laboratories dedicates whatever right, title or
// interest it may have in this software to the public. Although no
// license from Sandia is needed to copy and use this software,
// copying and using the software might infringe the rights of
// others. This software is provided as-is. SANDIA DISCLAIMS ANY
// WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.
//
// Encapsulation of test data structure
//

#ifndef TESTRECORD_H
#define TESTRECORD_H

#include <stdio.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif /* STDC_HEADERS */

#if HAVE_UNISTD_H
#include <sys/types.h>
#endif /* HAVE_UNISTD_H */

#include <sys/time.h>

#include "pc.h"
#include "Pctest.h"

class TestRecord {

  public:

    bool used;			// has this TestRecord been used yet?
    TestRecord *next;		// for supporting a SLL of these things

    unsigned int size;		// bytes in the packet in this test
    unsigned int hops;		// TTL used for this packet
    struct timeval tvstart;	// starting timestamp
    struct timeval tv;		// RTT recorded
    void *targetAddress;		// target address
    int targetAddressLength;	// length of target address
    void *icmpSourceAddress;		// source address of ICMP packet
    int icmpSourceAddressLength;	// length of source address
    void *icmpDestAddress;		// dest address of ICMP packet
    int icmpDestAddressLength;	// length of dest address
    int icmpType;		// ICMP type
    int icmpCode;		// ICMP code

    char *htoa(Pctest *pct);
    static TestRecord *atoh(char *);
#ifdef HAVE_IPV6
    static TestRecord *atoh6(char *);
#endif /* HAVE_IPV6 */

};

#endif /* TESTRECORD_H */

