// -*- c++ -*-
//
// $Id: PctestIpv6.h,v 1.3 2000/01/19 17:14:42 bmah Exp $
//
// PctestIpv6.h
// Bruce A. Mah <bmah@ca.sandia.gov>
//
// This work was first produced by an employee of Sandia National
// Laboratories under a contract with the U.S. Department of Energy.
// Sandia National Laboratories dedicates whatever right, title or
// interest it may have in this software to the public. Although no
// license from Sandia is needed to copy and use this software,
// copying and using the software might infringe the rights of
// others. This software is provided as-is. SANDIA DISCLAIMS ANY
// WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.
//
// Header class for IPv6 tests
//
#ifndef PCTESTIPV6_H
#define PCTESTIPV6_H

#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#if STDC_HEADERS
#include <string.h>
#endif /* STDC_HEADERS */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#if HAVE_STRINGS_H
#include <strings.h>
#endif /* HAVE_STRINGS_H */

#include "pc.h"
#include "Pctest.h"
#include "TestRecord.h"

class PctestIpv6 : public Pctest {

  public:

    PctestIpv6() { 
	socketOut = 0;
	socketIn = 0;
	destPort = 32768; 
    };
    PctestIpv6(int p) { 
	socketOut = 0;
	socketIn = 0;
	destPort = p; 
    };
    virtual ~PctestIpv6() { 
	if (socketOut > 0) {
	    close(socketOut);
	}
	if (socketIn > 0) {
	    close(socketIn);
	}
    };

    virtual int SetTargetName(char *target);
    virtual int GetSocketOut() = 0;
    virtual int GetSocketIn();
    virtual char *GetPrintableAddress();
    virtual char *GetPrintableAddress(void *a);
    virtual char *GetName(void *a);
    virtual char *GetAddressFamily() { return "AF_INET6"; }
    virtual int GetMinSize();
    virtual PctestActionType GetAction(TestRecord &tr);
    
  protected:

    struct in6_addr targetAddress;
    struct sockaddr_in6 targetSocketAddress;
    struct sockaddr_in6 icmpDestSocketAddress;
    struct sockaddr_in6 icmpSourceSocketAddress;

    int socketOut;		// output socket (RAW)
    int socketIn;		// input socket (ICMP)
    int proto;			// (hopefully) ICMP protocol number
    int destPort;		// destination port number

};

#endif /* PCTESTIPV6_H */


