static char rcsid[] = "$Id: Pctest.cc,v 1.6 2000/01/19 17:14:42 bmah Exp $";
//
// $Id: Pctest.cc,v 1.6 2000/01/19 17:14:42 bmah Exp $
//
// Pctest.cc
// Bruce A. Mah <bmah@ca.sandia.gov>
//
// This work was first produced by an employee of Sandia National
// Laboratories under a contract with the U.S. Department of Energy.
// Sandia National Laboratories dedicates whatever right, title or
// interest it may have in this software to the public. Although no
// license from Sandia is needed to copy and use this software,
// copying and using the software might infringe the rights of
// others. This software is provided as-is. SANDIA DISCLAIMS ANY
// WARRANTY OF ANY KIND, EXPRESS OR IMPLIED.
//
// Placeholder for virtual base class of tests.
//

#include <stdio.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif /* STDC_HEADERS */

#if HAVE_UNISTD_H
#include <sys/types.h>
#endif /* HAVE_UNISTD_H */

#include <sys/socket.h>
#include <sys/time.h>

#include "Pctest.h"

//
// Pctest::TimeSyscall
//
// Input:  None
//
// Output:  timeval to hold gettimeofday overhead
//
// Determine the gettimeofday() syscall overhead.  Probably this is going
// to be negligible compared to the data we're getting back from the
// network.
//
void Pctest::TimeSyscall(struct timeval &diff)
{
    struct timeval t1, t2;

    gettimeofday(&t1, NULL);
    gettimeofday(&t2, NULL);
    
    diff.tv_sec = t2.tv_sec - t1.tv_sec;
    diff.tv_usec = t2.tv_usec - t1.tv_usec;
    if (diff.tv_usec < 0) {
	diff.tv_usec += 1000000;
	diff.tv_sec--;
    }
    
}

//
// Pctest::GeneratePayload
//
// Input:  Number of bytes to get
//
// Output:  Pointer to payload (owned by caller, NULL if an error)
//
// Generate a random number of bytes in a heap-allocated buffer.
// for use as a payload.  Having random data in the packet will hopefully
// defeat link-level compression.
//
char *Pctest::GeneratePayload(int size)
{
    char *buf;
    int i;

    if (size <= 0) {
	return NULL;
    }

    buf = new char[size];
    if (buf == NULL) {
	return buf;
    }
    for (i = 0; i < size; i++) {
	buf[i] = random() & 0xff;
    }
    return buf;
}
