/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     NUMBER = 258,
     CHAR_CONST = 259,
     FLOAT = 260,
     STRING = 261,
     T_FILEVERSION = 262,
     T_PCB = 263,
     T_LAYER = 264,
     T_VIA = 265,
     T_RAT = 266,
     T_LINE = 267,
     T_ARC = 268,
     T_RECTANGLE = 269,
     T_TEXT = 270,
     T_ELEMENTLINE = 271,
     T_ELEMENT = 272,
     T_PIN = 273,
     T_PAD = 274,
     T_GRID = 275,
     T_FLAGS = 276,
     T_SYMBOL = 277,
     T_SYMBOLLINE = 278,
     T_CURSOR = 279,
     T_ELEMENTARC = 280,
     T_MARK = 281,
     T_GROUPS = 282,
     T_STYLES = 283,
     T_POLYGON = 284,
     T_NETLIST = 285,
     T_NET = 286,
     T_CONN = 287,
     T_AREA = 288,
     T_THERMAL = 289,
     T_DRC = 290,
     T_ATTRIBUTE = 291
   };
#endif
#define NUMBER 258
#define CHAR_CONST 259
#define FLOAT 260
#define STRING 261
#define T_FILEVERSION 262
#define T_PCB 263
#define T_LAYER 264
#define T_VIA 265
#define T_RAT 266
#define T_LINE 267
#define T_ARC 268
#define T_RECTANGLE 269
#define T_TEXT 270
#define T_ELEMENTLINE 271
#define T_ELEMENT 272
#define T_PIN 273
#define T_PAD 274
#define T_GRID 275
#define T_FLAGS 276
#define T_SYMBOL 277
#define T_SYMBOLLINE 278
#define T_CURSOR 279
#define T_ELEMENTARC 280
#define T_MARK 281
#define T_GROUPS 282
#define T_STYLES 283
#define T_POLYGON 284
#define T_NETLIST 285
#define T_NET 286
#define T_CONN 287
#define T_AREA 288
#define T_THERMAL 289
#define T_DRC 290
#define T_ATTRIBUTE 291




/* Copy the first part of user declarations.  */
#line 11 "parse_y.y"

/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995,1996 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 */

/* grammar to parse ASCII input of PCB description
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define GRIDFIT(x,g) (int)(0.5 + (int)(((x)+(g)/2.)/(g))*(g))
#include "global.h"
#include "create.h"
#include "data.h"
#include "error.h"
#include "file.h"
#include "mymem.h"
#include "misc.h"
#include "parse_l.h"
#include "polygon.h"
#include "remove.h"
#include "rtree.h"
#include "strflags.h"
#include "thermal.h"

#ifdef HAVE_LIBDMALLOC
# include <dmalloc.h> /* see http://dmalloc.com */
#endif

RCSID("$Id: parse_y.y,v 1.40 2007/04/21 21:21:55 djdelorie Exp $");

static	LayerTypePtr	Layer;
static	PolygonTypePtr	Polygon;
static	SymbolTypePtr	Symbol;
static	int		pin_num;
static	LibraryMenuTypePtr	Menu;
static	Boolean			LayerFlag[MAX_LAYER + 2];

extern	char			*yytext;		/* defined by LEX */
extern	PCBTypePtr		yyPCB;
extern	DataTypePtr		yyData;
extern	ElementTypePtr	yyElement;
extern	FontTypePtr		yyFont;
extern	int				yylineno;		/* linenumber */
extern	char			*yyfilename;	/* in this file */

static char *layer_group_string; 

static AttributeListTypePtr attr_list; 

int yyerror(const char *s);
int yylex();
static int check_file_version (int);



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 92 "parse_y.y"
typedef union YYSTYPE {
	int		number;
	float		floating;
	char		*string;
	FlagType	flagtype;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 234 "../../pcb-head/src/parse_y.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 246 "../../pcb-head/src/parse_y.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  10
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   585

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  41
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  104
/* YYNRULES -- Number of rules. */
#define YYNRULES  194
/* YYNRULES -- Number of states. */
#define YYNSTATES  607

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   291

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      39,    40,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    37,     2,    38,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    12,    27,    28,
      31,    32,    35,    37,    38,    39,    42,    43,    48,    53,
      60,    67,    69,    71,    73,    75,    82,    90,    98,   106,
     113,   120,   127,   128,   129,   134,   135,   140,   141,   143,
     145,   147,   154,   162,   172,   177,   182,   183,   188,   189,
     194,   199,   200,   202,   203,   205,   208,   210,   211,   214,
     216,   218,   219,   222,   224,   226,   228,   230,   232,   234,
     246,   258,   269,   279,   288,   299,   310,   311,   322,   324,
     325,   327,   330,   332,   334,   336,   338,   340,   342,   351,
     353,   355,   357,   358,   367,   378,   389,   399,   412,   425,
     437,   446,   456,   466,   468,   471,   476,   481,   482,   484,
     486,   488,   490,   492,   493,   506,   507,   523,   524,   541,
     542,   561,   562,   581,   583,   586,   588,   590,   592,   594,
     596,   605,   614,   625,   636,   642,   648,   649,   652,   654,
     657,   659,   661,   663,   665,   674,   683,   694,   705,   706,
     709,   722,   735,   746,   756,   765,   779,   793,   805,   816,
     818,   820,   822,   825,   826,   836,   837,   847,   849,   851,
     853,   856,   858,   860,   861,   870,   879,   881,   882,   889,
     891,   892,   894,   897,   898,   908,   910,   911,   913,   916,
     921,   923,   926,   932,   934
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
      42,     0,    -1,    43,    -1,    46,    -1,    49,    -1,     1,
      -1,    -1,    44,    51,    52,    53,    58,    59,    60,    61,
      65,    66,    67,    48,    68,   133,    -1,    -1,    45,    97,
      -1,    -1,    47,    68,    -1,    49,    -1,    -1,    -1,    50,
     124,    -1,    -1,     7,    37,     3,    38,    -1,     8,    39,
       6,    40,    -1,     8,    39,     6,     3,     3,    40,    -1,
       8,    37,     6,     3,     3,    38,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    20,    39,     3,     3,     3,
      40,    -1,    20,    39,     3,     3,     3,     3,    40,    -1,
      20,    39,     5,     3,     3,     3,    40,    -1,    20,    37,
       5,     3,     3,     3,    38,    -1,    24,    39,     3,     3,
       3,    40,    -1,    24,    37,     3,     3,     3,    38,    -1,
      24,    37,     3,     3,     5,    38,    -1,    -1,    -1,    33,
      37,     5,    38,    -1,    -1,    34,    37,     5,    38,    -1,
      -1,    62,    -1,    63,    -1,    64,    -1,    35,    37,     3,
       3,     3,    38,    -1,    35,    37,     3,     3,     3,     3,
      38,    -1,    35,    37,     3,     3,     3,     3,     3,     3,
      38,    -1,    21,    39,     3,    40,    -1,    21,    39,     6,
      40,    -1,    -1,    27,    39,     6,    40,    -1,    -1,    28,
      39,     6,    40,    -1,    28,    37,     6,    38,    -1,    -1,
      69,    -1,    -1,    70,    -1,    69,    70,    -1,    73,    -1,
      -1,    71,   142,    -1,    79,    -1,    80,    -1,    -1,    72,
      97,    -1,     1,    -1,    74,    -1,    75,    -1,    76,    -1,
      77,    -1,    78,    -1,    10,    37,     3,     3,     3,     3,
       3,     3,     6,   123,    38,    -1,    10,    39,     3,     3,
       3,     3,     3,     3,     6,     3,    40,    -1,    10,    39,
       3,     3,     3,     3,     3,     6,     3,    40,    -1,    10,
      39,     3,     3,     3,     3,     6,     3,    40,    -1,    10,
      39,     3,     3,     3,     6,     3,    40,    -1,    11,    37,
       3,     3,     3,     3,     3,     3,   123,    38,    -1,    11,
      39,     3,     3,     3,     3,     3,     3,     3,    40,    -1,
      -1,     9,    39,     3,     6,   144,    40,    39,    81,    82,
      40,    -1,    83,    -1,    -1,    84,    -1,    83,    84,    -1,
      86,    -1,    87,    -1,    88,    -1,    89,    -1,    90,    -1,
      91,    -1,    14,    39,     3,     3,     3,     3,     3,    40,
      -1,    94,    -1,    93,    -1,    92,    -1,    -1,    29,    39,
     123,    40,    39,    85,    95,    40,    -1,    12,    37,     3,
       3,     3,     3,     3,     3,   123,    38,    -1,    12,    39,
       3,     3,     3,     3,     3,     3,     3,    40,    -1,    12,
      39,     3,     3,     3,     3,     3,     3,    40,    -1,    13,
      37,     3,     3,     3,     3,     3,     3,     3,     3,   123,
      38,    -1,    13,    39,     3,     3,     3,     3,     3,     3,
       3,     3,     3,    40,    -1,    13,    39,     3,     3,     3,
       3,     3,     3,     3,     3,    40,    -1,    15,    39,     3,
       3,     3,     6,     3,    40,    -1,    15,    39,     3,     3,
       3,     3,     6,     3,    40,    -1,    15,    37,     3,     3,
       3,     3,     6,   123,    38,    -1,    96,    -1,    95,    96,
      -1,    39,     3,     3,    40,    -1,    37,     3,     3,    38,
      -1,    -1,    98,    -1,   100,    -1,   102,    -1,   104,    -1,
     106,    -1,    -1,    17,    39,     6,     6,     3,     3,     3,
      40,    39,    99,   108,    40,    -1,    -1,    17,    39,     3,
       6,     6,     3,     3,     3,     3,     3,    40,    39,   101,
     108,    40,    -1,    -1,    17,    39,     3,     6,     6,     6,
       3,     3,     3,     3,     3,    40,    39,   103,   108,    40,
      -1,    -1,    17,    39,     3,     6,     6,     6,     3,     3,
       3,     3,     3,     3,     3,    40,    39,   105,   111,    40,
      -1,    -1,    17,    37,   123,     6,     6,     6,     3,     3,
       3,     3,     3,     3,   123,    38,    39,   107,   111,    40,
      -1,   109,    -1,   108,   109,    -1,   116,    -1,   117,    -1,
     118,    -1,   121,    -1,   122,    -1,    16,    37,     3,     3,
       3,     3,     3,    38,    -1,    16,    39,     3,     3,     3,
       3,     3,    40,    -1,    25,    37,     3,     3,     3,     3,
       3,     3,     3,    38,    -1,    25,    39,     3,     3,     3,
       3,     3,     3,     3,    40,    -1,    26,    37,     3,     3,
      38,    -1,    26,    39,     3,     3,    40,    -1,    -1,   110,
     142,    -1,   112,    -1,   111,   112,    -1,   115,    -1,   114,
      -1,   120,    -1,   119,    -1,    16,    37,     3,     3,     3,
       3,     3,    38,    -1,    16,    39,     3,     3,     3,     3,
       3,    40,    -1,    25,    37,     3,     3,     3,     3,     3,
       3,     3,    38,    -1,    25,    39,     3,     3,     3,     3,
       3,     3,     3,    40,    -1,    -1,   113,   142,    -1,    18,
      37,     3,     3,     3,     3,     3,     3,     6,     6,   123,
      38,    -1,    18,    39,     3,     3,     3,     3,     3,     3,
       6,     6,     3,    40,    -1,    18,    39,     3,     3,     3,
       3,     6,     6,     3,    40,    -1,    18,    39,     3,     3,
       3,     3,     6,     3,    40,    -1,    18,    39,     3,     3,
       3,     6,     3,    40,    -1,    19,    37,     3,     3,     3,
       3,     3,     3,     3,     6,     6,   123,    38,    -1,    19,
      39,     3,     3,     3,     3,     3,     3,     3,     6,     6,
       3,    40,    -1,    19,    39,     3,     3,     3,     3,     3,
       6,     6,     3,    40,    -1,    19,    39,     3,     3,     3,
       3,     3,     6,     3,    40,    -1,     3,    -1,     6,    -1,
     125,    -1,   124,   125,    -1,    -1,    22,    37,   128,     3,
      38,    39,   126,   129,    40,    -1,    -1,    22,    39,   128,
       3,    40,    39,   127,   129,    40,    -1,     3,    -1,     4,
      -1,   130,    -1,   129,   130,    -1,   131,    -1,   132,    -1,
      -1,    23,    39,     3,     3,     3,     3,     3,    40,    -1,
      23,    37,     3,     3,     3,     3,     3,    38,    -1,   134,
      -1,    -1,    30,    39,    40,    39,   135,    40,    -1,   136,
      -1,    -1,   137,    -1,   136,   137,    -1,    -1,    31,    39,
       6,     6,    40,    39,   138,   139,    40,    -1,   140,    -1,
      -1,   141,    -1,   140,   141,    -1,    32,    39,     6,    40,
      -1,   143,    -1,   142,   143,    -1,    36,    39,     6,     6,
      40,    -1,     6,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   115,   115,   116,   117,   118,   142,   142,   193,   193,
     204,   204,   223,   224,   229,   229,   268,   270,   302,   308,
     314,   343,   344,   345,   346,   349,   357,   370,   382,   414,
     420,   426,   432,   448,   450,   472,   474,   505,   507,   508,
     509,   513,   522,   532,   559,   563,   567,   595,   599,   643,
     651,   659,   663,   664,   668,   669,   673,   674,   674,   675,
     676,   678,   678,   685,   689,   690,   691,   692,   693,   729,
     738,   749,   759,   769,   805,   810,   842,   841,   865,   866,
     870,   871,   875,   876,   877,   878,   879,   880,   882,   887,
     888,   889,   892,   891,   944,   952,   961,  1009,  1017,  1026,
    1063,  1073,  1091,  1132,  1133,  1138,  1142,  1146,  1203,  1204,
    1205,  1206,  1207,  1215,  1214,  1233,  1232,  1251,  1250,  1271,
    1269,  1292,  1290,  1370,  1371,  1375,  1376,  1377,  1378,  1379,
    1381,  1386,  1391,  1396,  1401,  1406,  1411,  1411,  1415,  1416,
    1420,  1421,  1422,  1423,  1425,  1431,  1438,  1443,  1448,  1448,
    1489,  1501,  1513,  1524,  1540,  1594,  1608,  1621,  1632,  1643,
    1644,  1648,  1649,  1673,  1672,  1690,  1689,  1709,  1710,  1714,
    1715,  1719,  1720,  1721,  1742,  1749,  1765,  1766,  1770,  1775,
    1776,  1780,  1781,  1804,  1803,  1813,  1814,  1818,  1819,  1838,
    1867,  1868,  1871,  1879,  1880
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "NUMBER", "CHAR_CONST", "FLOAT", "STRING", 
  "T_FILEVERSION", "T_PCB", "T_LAYER", "T_VIA", "T_RAT", "T_LINE", 
  "T_ARC", "T_RECTANGLE", "T_TEXT", "T_ELEMENTLINE", "T_ELEMENT", "T_PIN", 
  "T_PAD", "T_GRID", "T_FLAGS", "T_SYMBOL", "T_SYMBOLLINE", "T_CURSOR", 
  "T_ELEMENTARC", "T_MARK", "T_GROUPS", "T_STYLES", "T_POLYGON", 
  "T_NETLIST", "T_NET", "T_CONN", "T_AREA", "T_THERMAL", "T_DRC", 
  "T_ATTRIBUTE", "'['", "']'", "'('", "')'", "$accept", "parse", 
  "parsepcb", "@1", "@2", "parsedata", "@3", "pcbfont", "parsefont", "@4", 
  "pcbfileversion", "pcbname", "pcbgrid", "pcbgridold", "pcbgridnew", 
  "pcb2grid", "pcbhigrid", "pcbcursor", "polyarea", "pcbthermal", 
  "pcbdrc", "pcbdrc1", "pcbdrc2", "pcbdrc3", "pcbflags", "pcbgroups", 
  "pcbstyles", "pcbdata", "pcbdefinitions", "pcbdefinition", "@5", "@6", 
  "via", "via_hi_format", "via_2.0_format", "via_1.7_format", 
  "via_newformat", "via_oldformat", "rats", "layer", "@7", "layerdata", 
  "layerdefinitions", "layerdefinition", "@8", "line_hi_format", 
  "line_1.7_format", "line_oldformat", "arc_hi_format", "arc_1.7_format", 
  "arc_oldformat", "text_oldformat", "text_newformat", "text_hi_format", 
  "polygonpoints", "polygonpoint", "element", "element_oldformat", "@9", 
  "element_1.3.4_format", "@10", "element_newformat", "@11", 
  "element_1.7_format", "@12", "element_hi_format", "@13", 
  "elementdefinitions", "elementdefinition", "@14", "relementdefs", 
  "relementdef", "@15", "pin_hi_format", "pin_1.7_format", 
  "pin_1.6.3_format", "pin_newformat", "pin_oldformat", "pad_hi_format", 
  "pad_1.7_format", "pad_newformat", "pad", "flags", "symbols", "symbol", 
  "@16", "@17", "symbolid", "symboldata", "symboldefinitions", 
  "symboldefinition", "hiressymbol", "pcbnetlist", "pcbnetdef", "nets", 
  "netdefs", "net", "@18", "connections", "conndefs", "conn", 
  "attributes", "attribute", "opt_string", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,    91,    93,    40,
      41
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    41,    42,    42,    42,    42,    44,    43,    45,    43,
      47,    46,    48,    48,    50,    49,    51,    51,    52,    52,
      52,    53,    53,    53,    53,    54,    55,    56,    57,    58,
      58,    58,    58,    59,    59,    60,    60,    61,    61,    61,
      61,    62,    63,    64,    65,    65,    65,    66,    66,    67,
      67,    67,    68,    68,    69,    69,    70,    71,    70,    70,
      70,    72,    70,    70,    73,    73,    73,    73,    73,    74,
      75,    76,    77,    78,    79,    79,    81,    80,    82,    82,
      83,    83,    84,    84,    84,    84,    84,    84,    84,    84,
      84,    84,    85,    84,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    95,    96,    96,    96,    97,    97,
      97,    97,    97,    99,    98,   101,   100,   103,   102,   105,
     104,   107,   106,   108,   108,   109,   109,   109,   109,   109,
     109,   109,   109,   109,   109,   109,   110,   109,   111,   111,
     112,   112,   112,   112,   112,   112,   112,   112,   113,   112,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     123,   124,   124,   126,   125,   127,   125,   128,   128,   129,
     129,   130,   130,   130,   131,   132,   133,   133,   134,   135,
     135,   136,   136,   138,   137,   139,   139,   140,   140,   141,
     142,   142,   143,   144,   144
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     0,    14,     0,     2,
       0,     2,     1,     0,     0,     2,     0,     4,     4,     6,
       6,     1,     1,     1,     1,     6,     7,     7,     7,     6,
       6,     6,     0,     0,     4,     0,     4,     0,     1,     1,
       1,     6,     7,     9,     4,     4,     0,     4,     0,     4,
       4,     0,     1,     0,     1,     2,     1,     0,     2,     1,
       1,     0,     2,     1,     1,     1,     1,     1,     1,    11,
      11,    10,     9,     8,    10,    10,     0,    10,     1,     0,
       1,     2,     1,     1,     1,     1,     1,     1,     8,     1,
       1,     1,     0,     8,    10,    10,     9,    12,    12,    11,
       8,     9,     9,     1,     2,     4,     4,     0,     1,     1,
       1,     1,     1,     0,    12,     0,    15,     0,    16,     0,
      18,     0,    18,     1,     2,     1,     1,     1,     1,     1,
       8,     8,    10,    10,     5,     5,     0,     2,     1,     2,
       1,     1,     1,     1,     8,     8,    10,    10,     0,     2,
      12,    12,    10,     9,     8,    13,    13,    11,    10,     1,
       1,     1,     2,     0,     9,     0,     9,     1,     1,     1,
       2,     1,     1,     0,     8,     8,     1,     0,     6,     1,
       0,     1,     2,     0,     9,     1,     0,     1,     2,     4,
       1,     2,     5,     1,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     5,     0,     2,    16,     0,     3,     0,     4,     0,
       1,     0,     0,     0,     9,   108,   109,   110,   111,   112,
      63,     0,     0,     0,    11,     0,    54,     0,     0,    56,
      64,    65,    66,    67,    68,    59,    60,     0,    15,   161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,     0,    58,   190,    62,     0,     0,   162,     0,     0,
       0,     0,    32,    21,    22,    23,    24,   159,   160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   191,   167,
     168,     0,     0,    17,     0,     0,     0,     0,     0,    33,
       0,     0,     0,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    18,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,   193,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   192,   163,   165,    20,    19,     0,     0,
       0,     0,     0,     0,     0,     0,    46,    38,    39,    40,
       0,     0,     0,     0,    76,     0,     0,     0,     0,     0,
       0,   173,   173,     0,     0,    25,     0,     0,     0,     0,
      34,     0,     0,     0,    48,     0,     0,     0,     0,    79,
       0,     0,     0,     0,    73,     0,     0,     0,     0,   169,
     171,   172,     0,    28,    26,    27,    30,    31,    29,    36,
       0,     0,     0,    51,     0,     0,     0,   113,     0,     0,
       0,     0,     0,     0,    78,    80,    82,    83,    84,    85,
      86,    87,    91,    90,    89,     0,     0,     0,    72,     0,
       0,     0,     0,   164,   170,   166,     0,     0,     0,     0,
       0,    13,     0,     0,     0,   136,     0,     0,     0,     0,
       0,     0,     0,     0,    77,    81,     0,     0,    71,    74,
      75,     0,     0,     0,    44,    45,     0,     0,     0,     0,
      12,     0,     0,     0,     0,     0,     0,     0,     0,   136,
     123,     0,   125,   126,   127,   128,   129,     0,     0,     0,
       0,     0,     0,     0,     0,    69,    70,     0,     0,     0,
      41,    47,     0,     0,   177,     0,   115,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   114,   124,   137,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    42,    50,    49,     0,     7,   176,     0,   136,     0,
     117,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    92,     0,     0,     0,
       0,     0,   136,     0,   136,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   107,     0,     0,    43,     0,   121,   116,   119,   136,
       0,     0,     0,     0,     0,     0,   134,   135,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   103,
     175,   174,   180,   148,   148,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    88,     0,     0,
     100,     0,     0,    93,   104,     0,     0,   179,   181,     0,
       0,     0,     0,   148,   138,     0,   141,   140,   143,   142,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      96,     0,     0,   102,   101,     0,     0,     0,   178,   182,
       0,     0,     0,     0,     0,     0,     0,     0,   122,   139,
     149,   120,   130,   131,     0,     0,   154,     0,     0,     0,
      94,    95,     0,     0,   106,   105,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   153,     0,     0,     0,     0,
       0,     0,     0,    99,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   152,   158,     0,   132,   133,    97,    98,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   157,
     183,     0,     0,     0,     0,     0,     0,     0,     0,   186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     185,   187,   144,   145,     0,     0,     0,     0,     0,     0,
       0,   184,   188,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   146,   147,   189,     0,     0,     0,
       0,   150,   151,     0,     0,   155,   156
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     2,     3,     4,     5,     6,     7,   279,     8,     9,
      12,    42,    62,    63,    64,    65,    66,    89,   110,   132,
     156,   157,   158,   159,   184,   213,   251,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
     189,   223,   224,   225,   391,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   418,   419,    14,    15,   255,    16,
     348,    17,   374,    18,   424,    19,   423,   289,   290,   291,
     453,   454,   455,   456,   457,   292,   293,   294,   458,   459,
     295,   296,    69,    38,    39,   171,   172,    81,   198,   199,
     200,   201,   345,   346,   446,   447,   448,   559,   569,   570,
     571,    52,    53,   115
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -398
static const short yypact[] =
{
      11,  -398,    32,  -398,     9,    37,  -398,    14,  -398,    18,
    -398,    29,    67,    16,  -398,  -398,  -398,  -398,  -398,  -398,
    -398,    60,   120,   123,  -398,    48,  -398,    64,    37,  -398,
    -398,  -398,  -398,  -398,  -398,  -398,  -398,   124,    18,  -398,
     107,   128,    91,    79,    86,   112,   125,   138,   155,   174,
    -398,    83,    64,  -398,  -398,    23,    23,  -398,    88,   158,
     177,   131,   110,  -398,  -398,  -398,  -398,  -398,  -398,   178,
     196,   198,   199,   203,   204,   205,   206,   207,  -398,  -398,
    -398,   208,   209,  -398,   211,     2,   137,   151,   132,   122,
     210,   212,   214,   215,   217,   219,   220,   221,   222,   172,
     175,   223,   224,  -398,   226,   227,   228,   229,   230,   188,
     200,   231,    98,   232,  -398,   201,   233,   103,   235,   237,
     202,   213,   216,   218,   225,   240,   241,   242,   243,   244,
     245,   234,   238,   246,   248,   250,   251,   236,   254,   117,
     255,   256,   257,  -398,  -398,  -398,  -398,  -398,   258,     3,
     259,   169,   260,   247,   261,   239,   249,  -398,  -398,  -398,
     264,   265,   266,   252,  -398,   269,   121,   271,   253,   275,
     276,   263,   263,   262,   267,  -398,   270,   268,   273,   272,
    -398,   277,   278,   274,   282,   279,   280,   281,   283,   118,
     284,   285,   286,   287,  -398,    79,   291,   136,   -10,  -398,
    -398,  -398,    -6,  -398,  -398,  -398,  -398,  -398,  -398,  -398,
     292,   133,   289,   288,   293,   294,   295,  -398,   139,   142,
     290,   143,   296,   297,   118,  -398,  -398,  -398,  -398,  -398,
    -398,  -398,  -398,  -398,  -398,    79,   298,   299,  -398,   300,
     301,   302,   311,  -398,  -398,  -398,   314,   303,   304,   312,
     148,   308,   316,   305,   317,   119,   318,   320,   321,   322,
     323,   328,   329,    79,  -398,  -398,   309,   306,  -398,  -398,
    -398,   330,   331,     1,  -398,  -398,   310,   334,   336,    51,
    -398,   333,   313,     4,   149,   315,   319,   152,   153,    54,
    -398,    64,  -398,  -398,  -398,  -398,  -398,   345,   346,   348,
     350,   352,   353,   354,   324,  -398,  -398,   356,   357,    26,
    -398,  -398,   325,   326,   332,    79,  -398,   358,   335,   362,
     364,   365,   366,   367,   368,   369,   370,  -398,  -398,    64,
     372,   373,   374,   375,   376,   377,   378,   343,   380,   381,
     382,  -398,  -398,  -398,   347,  -398,  -398,   349,   119,   351,
    -398,   385,   386,   387,   389,   390,   391,   392,   394,   395,
     396,   397,   398,   399,   400,   140,  -398,   401,   403,   371,
     379,   383,    72,   384,   119,   404,   405,   407,   408,   409,
     410,   388,   393,   411,   412,   413,   414,   415,   418,   419,
     417,   156,   402,   406,  -398,   416,  -398,  -398,  -398,    77,
     424,   425,   145,   426,   427,   428,  -398,  -398,   429,   431,
     432,   433,   420,    79,   434,   421,   436,   438,    -2,  -398,
    -398,  -398,   422,    58,    58,  -398,   439,   440,   441,   442,
     445,   446,   447,    79,     5,   448,   449,  -398,   430,   423,
    -398,   451,   453,  -398,  -398,   435,   437,   422,  -398,   157,
     160,   161,   164,    89,  -398,    64,  -398,  -398,  -398,  -398,
     100,   443,   444,   146,   450,   452,   454,   456,   455,   457,
    -398,   459,   461,  -398,  -398,   458,   460,   463,  -398,  -398,
     462,   464,   467,   468,   469,   470,   472,   473,  -398,  -398,
      64,  -398,  -398,  -398,   465,   475,  -398,   147,   476,   477,
    -398,  -398,    79,     6,  -398,  -398,   479,   480,   483,   484,
     485,   486,   488,   489,   491,  -398,   466,   471,   492,   474,
     478,   481,   482,  -398,   487,   495,   496,   498,   499,   500,
     501,   504,   505,  -398,  -398,   490,  -398,  -398,  -398,  -398,
     493,   506,   507,   510,   511,   512,   513,   514,   517,  -398,
    -398,   518,   520,   521,   522,   523,   525,   526,   528,   502,
     497,   503,   530,   533,   534,   535,   536,   537,   508,   509,
     502,  -398,  -398,  -398,   538,   539,   543,   545,   547,   548,
     546,  -398,  -398,   549,   550,   551,   552,   515,   519,   524,
      79,   557,   555,   556,  -398,  -398,  -398,   516,   527,    79,
     560,  -398,  -398,   531,   532,  -398,  -398
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,    -3,  -398,
    -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,
    -398,  -398,  -398,  -398,  -398,  -398,  -398,   -15,  -398,   540,
    -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,
    -398,  -398,  -398,    56,  -398,  -398,  -398,  -398,  -398,  -398,
    -398,  -398,  -398,  -398,  -398,  -130,   542,  -398,  -398,  -398,
    -398,  -398,  -398,  -398,  -398,  -398,  -398,  -338,  -286,  -398,
    -137,  -397,  -398,  -398,  -398,  -398,  -398,  -398,  -398,  -398,
    -398,  -398,  -194,  -398,   541,  -398,  -398,   529,   127,  -131,
    -398,  -398,  -398,  -398,  -398,  -398,  -145,  -398,  -398,  -398,
    -267,  -289,   -52,  -398
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -62
static const short yytable[] =
{
      78,   239,   329,   328,   309,   102,   174,   317,   469,   522,
     372,   -10,     1,   197,   -53,    20,    11,   197,    -6,    -6,
     -10,   -10,   -10,    21,    22,    23,    79,    80,    -8,   340,
     243,   -61,    10,   -14,   245,   416,   399,   417,   443,   310,
      37,   266,   103,   175,   318,   470,   523,   -10,   -52,    20,
     -57,   -53,    20,    43,    13,    44,   489,    21,    22,    23,
      21,    22,    23,   489,   341,   -61,    40,   244,   -61,   304,
     284,   244,   285,   286,   449,    41,   450,   451,   -52,   287,
     288,   -53,    67,   452,   -57,    68,   328,   -57,   284,    70,
     285,   286,    71,   284,   327,   285,   286,   287,   288,    45,
      51,   134,   287,   288,   135,   449,   139,   450,   451,   140,
      58,    61,   397,   328,   452,    72,   449,   425,   450,   451,
     166,   347,    77,   167,   191,   452,    83,   192,    73,   488,
     218,   219,   220,   221,    88,   284,   247,   285,   286,   248,
     491,    74,   104,   389,   287,   288,   390,   222,   428,   494,
     517,   429,   495,   518,   105,   109,   106,    46,    75,    47,
      48,    55,    49,    56,    84,    59,   490,    60,    86,   107,
      87,   108,   177,   241,   178,   242,   256,    76,   257,   258,
     261,   259,   262,    85,    90,   277,   319,   278,   320,   323,
     325,   324,   326,   416,   480,   417,   481,   482,   484,   483,
     485,   486,    91,   487,    92,    93,    94,    95,    96,    97,
     121,    99,   100,    98,   101,   122,   111,   113,   112,   438,
     116,   114,   117,   118,   119,   130,   123,   124,   120,   125,
     126,   127,   128,   129,   131,   136,   138,   133,   141,   468,
     142,   137,   143,   148,   149,   150,   151,   152,   280,   160,
     153,   161,   144,   162,   163,   145,   146,   165,   168,   169,
     170,   173,   176,   179,   314,   147,   181,   185,   186,   187,
     183,   154,   190,   155,   193,   164,   182,    78,   195,   196,
     265,   210,   214,   215,   216,   180,   197,   460,   444,   237,
     235,   236,   188,   194,   240,   246,   252,   253,   254,   202,
     203,   267,   479,   582,     0,   271,   206,   204,   521,   212,
     205,   207,   208,   211,   272,   209,   250,   273,   276,   281,
     283,   297,   217,   298,   299,   300,   301,   238,   249,   260,
     -14,   302,   303,   307,   308,   263,   315,   264,   269,   268,
     312,   270,   313,   274,   275,   282,   306,   305,   330,   331,
     311,   332,   316,   333,   321,   334,   335,   336,   322,   338,
     339,   349,   344,   342,   337,   351,   343,   352,   353,   354,
     355,   356,   357,   358,   350,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   375,   376,
     377,   373,   378,   379,   380,   381,   597,   382,   383,   384,
     385,   386,   387,   388,   392,   603,   393,   400,   401,   394,
     402,   403,   404,   405,   408,   409,   410,   411,   412,   395,
     415,     0,   396,   398,   413,   414,   406,   426,   427,   430,
     431,   432,   433,   407,   434,   435,   436,   439,    78,   441,
     420,   442,   461,   462,     0,   464,   421,   463,   465,   466,
     467,   471,   472,   445,   475,   422,   476,   498,   497,   499,
     437,   440,   502,   474,   503,   507,     0,   508,   473,   506,
     509,   510,   511,   512,   477,   513,   514,   478,   516,   519,
     520,   492,     0,   525,   493,   524,   526,   527,   528,   529,
     496,   530,   531,   500,   532,   535,   504,   501,   541,   542,
     505,   543,   544,   545,   546,   515,   533,   547,   548,   551,
     552,   534,   536,   553,   554,   555,   556,   557,   537,   538,
     558,   560,   539,   561,   562,   563,   564,   540,   565,   566,
     549,   567,   550,   574,   568,   572,   575,   576,   577,   578,
     579,     0,     0,   573,   583,   584,   585,   580,   586,   581,
     587,   588,   589,   594,   601,   590,   591,   592,   593,   595,
     598,   599,   600,   604,   596,    50,     0,   602,     0,   605,
      54,     0,   606,     0,     0,     0,     0,     0,     0,    57,
       0,     0,     0,     0,     0,    82
};

static const short yycheck[] =
{
      52,   195,   291,   289,     3,     3,     3,     3,     3,     3,
     348,     0,     1,    23,     0,     1,     7,    23,     7,     8,
       9,    10,    11,     9,    10,    11,     3,     4,    17,     3,
      40,    17,     0,    22,    40,    37,   374,    39,    40,    38,
      22,   235,    40,    40,    40,    40,    40,    36,     0,     1,
      36,     0,     1,    37,    17,    39,   453,     9,    10,    11,
       9,    10,    11,   460,    38,    17,    37,   198,    17,   263,
      16,   202,    18,    19,    16,     8,    18,    19,    30,    25,
      26,    30,     3,    25,    36,     6,   372,    36,    16,     3,
      18,    19,     6,    16,    40,    18,    19,    25,    26,    39,
      36,     3,    25,    26,     6,    16,     3,    18,    19,     6,
       3,    20,    40,   399,    25,     3,    16,    40,    18,    19,
       3,   315,    39,     6,     3,    25,    38,     6,     3,    40,
      12,    13,    14,    15,    24,    16,     3,    18,    19,     6,
      40,     3,     5,     3,    25,    26,     6,    29,     3,     3,
       3,     6,     6,     6,     3,    33,     5,    37,     3,    39,
      37,    37,    39,    39,     6,    37,   455,    39,    37,    37,
      39,    39,     3,    37,     5,    39,    37,     3,    39,    37,
      37,    39,    39,     6,     6,    37,    37,    39,    39,    37,
      37,    39,    39,    37,    37,    39,    39,    37,    37,    39,
      39,    37,     6,    39,     6,     6,     3,     3,     3,     3,
      38,     3,     3,     6,     3,    40,     6,     3,     6,   413,
       3,     6,     3,     3,     3,    37,     3,     3,     6,     3,
       3,     3,     3,     3,    34,     3,     3,     6,     3,   433,
       3,    40,    40,     3,     3,     3,     3,     3,   251,     3,
       5,     3,    39,     3,     3,    39,    38,     3,     3,     3,
       3,     3,     3,     3,   279,    40,     5,     3,     3,     3,
      21,    37,     3,    35,     3,    39,    37,   329,     3,     3,
     224,     3,     3,     3,     3,    38,    23,   424,   418,     3,
       6,     6,    40,    40,     3,     3,     3,     3,     3,   172,
      38,     3,   447,   570,    -1,     3,    38,    40,   502,    27,
      40,    38,    40,    39,     3,    38,    28,     3,     6,     3,
       3,     3,    39,     3,     3,     3,     3,    40,    39,    39,
      22,     3,     3,     3,     3,    39,     3,    40,    38,    40,
       6,    40,     6,    40,    40,    40,    40,    38,     3,     3,
      40,     3,    39,     3,    39,     3,     3,     3,    39,     3,
       3,     3,    30,    38,    40,     3,    40,     3,     3,     3,
       3,     3,     3,     3,    39,     3,     3,     3,     3,     3,
       3,     3,    39,     3,     3,     3,    39,    38,     3,     3,
       3,    40,     3,     3,     3,     3,   590,     3,     3,     3,
       3,     3,     3,     3,     3,   599,     3,     3,     3,    38,
       3,     3,     3,     3,     3,     3,     3,     3,     3,    40,
       3,    -1,    39,    39,     6,     6,    38,     3,     3,     3,
       3,     3,     3,    40,     3,     3,     3,     3,   490,     3,
      38,     3,     3,     3,    -1,     3,    40,     6,     3,     3,
       3,     3,     3,    31,     3,    39,     3,     3,     6,     3,
      40,    40,     3,    40,     3,     3,    -1,     3,    38,     6,
       3,     3,     3,     3,    39,     3,     3,    40,     3,     3,
       3,    38,    -1,     3,    40,     6,     3,     3,     3,     3,
      40,     3,     3,    38,     3,     3,    38,    40,     3,     3,
      40,     3,     3,     3,     3,    40,    40,     3,     3,     3,
       3,    40,    38,     3,     3,     3,     3,     3,    40,    38,
       3,     3,    40,     3,     3,     3,     3,    40,     3,     3,
      40,     3,    39,     3,    32,    38,     3,     3,     3,     3,
       3,    -1,    -1,    40,     6,     6,     3,    39,     3,    40,
       3,     3,     6,    38,    38,     6,     6,     6,     6,    40,
       3,     6,     6,     3,    40,    25,    -1,    40,    -1,    38,
      28,    -1,    40,    -1,    -1,    -1,    -1,    -1,    -1,    38,
      -1,    -1,    -1,    -1,    -1,    56
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    42,    43,    44,    45,    46,    47,    49,    50,
       0,     7,    51,    17,    97,    98,   100,   102,   104,   106,
       1,     9,    10,    11,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    22,   124,   125,
      37,     8,    52,    37,    39,    39,    37,    39,    37,    39,
      70,    36,   142,   143,    97,    37,    39,   125,     3,    37,
      39,    20,    53,    54,    55,    56,    57,     3,     6,   123,
       3,     6,     3,     3,     3,     3,     3,    39,   143,     3,
       4,   128,   128,    38,     6,     6,    37,    39,    24,    58,
       6,     6,     6,     6,     3,     3,     3,     3,     6,     3,
       3,     3,     3,    40,     5,     3,     5,    37,    39,    33,
      59,     6,     6,     3,     6,   144,     3,     3,     3,     3,
       6,    38,    40,     3,     3,     3,     3,     3,     3,     3,
      37,    34,    60,     6,     3,     6,     3,    40,     3,     3,
       6,     3,     3,    40,    39,    39,    38,    40,     3,     3,
       3,     3,     3,     5,    37,    35,    61,    62,    63,    64,
       3,     3,     3,     3,    39,     3,     3,     6,     3,     3,
       3,   126,   127,     3,     3,    40,     3,     3,     5,     3,
      38,     5,    37,    21,    65,     3,     3,     3,    40,    81,
       3,     3,     6,     3,    40,     3,     3,    23,   129,   130,
     131,   132,   129,    38,    40,    40,    38,    38,    40,    38,
       3,    39,    27,    66,     3,     3,     3,    39,    12,    13,
      14,    15,    29,    82,    83,    84,    86,    87,    88,    89,
      90,    91,    92,    93,    94,     6,     6,     3,    40,   123,
       3,    37,    39,    40,   130,    40,     3,     3,     6,    39,
      28,    67,     3,     3,     3,    99,    37,    39,    37,    39,
      39,    37,    39,    39,    40,    84,   123,     3,    40,    38,
      40,     3,     3,     3,    40,    40,     6,    37,    39,    48,
      49,     3,    40,     3,    16,    18,    19,    25,    26,   108,
     109,   110,   116,   117,   118,   121,   122,     3,     3,     3,
       3,     3,     3,     3,   123,    38,    40,     3,     3,     3,
      38,    40,     6,     6,    68,     3,    39,     3,    40,    37,
      39,    39,    39,    37,    39,    37,    39,    40,   109,   142,
       3,     3,     3,     3,     3,     3,     3,    40,     3,     3,
       3,    38,    38,    40,    30,   133,   134,   123,   101,     3,
      39,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,    39,     3,     3,     3,
      39,    38,   108,    40,   103,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       6,    85,     3,     3,    38,    40,    39,    40,    39,   108,
       3,     3,     3,     3,     3,     3,    38,    40,     3,     3,
       3,     3,     3,     6,     6,     3,    37,    39,    95,    96,
      38,    40,    39,   107,   105,    40,     3,     3,     3,     6,
       3,     3,     3,     3,     3,     3,     3,    40,   123,     3,
      40,     3,     3,    40,    96,    31,   135,   136,   137,    16,
      18,    19,    25,   111,   112,   113,   114,   115,   119,   120,
     111,     3,     3,     6,     3,     3,     3,     3,   123,     3,
      40,     3,     3,    38,    40,     3,     3,    39,    40,   137,
      37,    39,    37,    39,    37,    39,    37,    39,    40,   112,
     142,    40,    38,    40,     3,     6,    40,     6,     3,     3,
      38,    40,     3,     3,    38,    40,     6,     3,     3,     3,
       3,     3,     3,     3,     3,    40,     3,     3,     6,     3,
       3,   123,     3,    40,     6,     3,     3,     3,     3,     3,
       3,     3,     3,    40,    40,     3,    38,    40,    38,    40,
      40,     3,     3,     3,     3,     3,     3,     3,     3,    40,
      39,     3,     3,     3,     3,     3,     3,     3,     3,   138,
       3,     3,     3,     3,     3,     3,     3,     3,    32,   139,
     140,   141,    38,    40,     3,     3,     3,     3,     3,     3,
      39,    40,   141,     6,     6,     3,     3,     3,     3,     6,
       6,     6,     6,     6,    38,    40,    40,   123,     3,     6,
       6,    38,    40,   123,     3,    38,    40
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 118 "parse_y.y"
    { YYABORT; }
    break;

  case 6:
#line 142 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyPCB)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
				yyFont = &yyPCB->Font;
				yyData = yyPCB->Data;
				yyData->pcb = (void *)yyPCB;
				yyData->LayerN = 0;
				layer_group_string = NULL;
			}
    break;

  case 7:
#line 174 "parse_y.y"
    {
			  int i, j;

			  if (layer_group_string == NULL)
			    layer_group_string = Settings.Groups;
			  CreateNewPCBPost (yyPCB, 0);
			  if (ParseGroupString(layer_group_string, &yyPCB->LayerGroups, yyData->LayerN))
			    {
			      Message("illegal layer-group string\n");
			      YYABORT;
			    }
			/* initialize the polygon clipping now since
			 * we didn't know the layer grouping before.
			 */
			for (i = 0; i < yyData->LayerN; i++)
			  for (j = 0; j < yyData->Layer[i].PolygonN; j++)
			      InitClip (yyData, &yyData->Layer[i], &yyData->Layer[i].Polygon[j]);
			}
    break;

  case 8:
#line 193 "parse_y.y"
    { PreLoadElementPCB ();
		    layer_group_string = NULL; }
    break;

  case 9:
#line 196 "parse_y.y"
    { LayerFlag[0] = True;
		    LayerFlag[1] = True;
		    yyData->LayerN = 2;
		    PostLoadElementPCB ();
		  }
    break;

  case 10:
#line 204 "parse_y.y"
    {
					/* reset flags for 'used layers';
					 * init font and data pointers
					 */
				int	i;

				if (!yyData || !yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				for (i = 0; i < MAX_LAYER + 2; i++)
					LayerFlag[i] = False;
				yyData->LayerN = 0;
			}
    break;

  case 14:
#line 229 "parse_y.y"
    {
					/* mark all symbols invalid */
				int	i;

				if (!yyFont)
				{
					Message("illegal fileformat\n");
					YYABORT;
				}
				yyFont->Valid = False;
				for (i = 0; i <= MAX_FONTPOSITION; i++)
					yyFont->Symbol[i].Valid = False;
			}
    break;

  case 15:
#line 243 "parse_y.y"
    {
				yyFont->Valid = True;
		  		SetFontInfo(yyFont);
			}
    break;

  case 17:
#line 271 "parse_y.y"
    {
  if (check_file_version (yyvsp[-1].number) != 0)
    {
      YYABORT;
    }
}
    break;

  case 18:
#line 303 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-1].string;
				yyPCB->MaxWidth = MAX_COORD;
				yyPCB->MaxHeight = MAX_COORD;
			}
    break;

  case 19:
#line 309 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number*100;
				yyPCB->MaxHeight = yyvsp[-1].number*100;
			}
    break;

  case 20:
#line 315 "parse_y.y"
    {
				yyPCB->Name = yyvsp[-3].string;
				yyPCB->MaxWidth = yyvsp[-2].number;
				yyPCB->MaxHeight = yyvsp[-1].number;
			}
    break;

  case 25:
#line 350 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-3].number*100;
				yyPCB->GridOffsetX = yyvsp[-2].number*100;
				yyPCB->GridOffsetY = yyvsp[-1].number*100;
			}
    break;

  case 26:
#line 358 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].number*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 27:
#line 371 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating*100;
				yyPCB->GridOffsetX = yyvsp[-3].number*100;
				yyPCB->GridOffsetY = yyvsp[-2].number*100;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 28:
#line 383 "parse_y.y"
    {
				yyPCB->Grid = yyvsp[-4].floating;
				yyPCB->GridOffsetX = yyvsp[-3].number;
				yyPCB->GridOffsetY = yyvsp[-2].number;
				if (yyvsp[-1].number)
					Settings.DrawGrid = True;
				else
					Settings.DrawGrid = False;
			}
    break;

  case 29:
#line 415 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number*100;
				yyPCB->CursorY = yyvsp[-2].number*100;
				yyPCB->Zoom = yyvsp[-1].number*2;
			}
    break;

  case 30:
#line 421 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].number;
			}
    break;

  case 31:
#line 427 "parse_y.y"
    {
				yyPCB->CursorX = yyvsp[-3].number;
				yyPCB->CursorY = yyvsp[-2].number;
				yyPCB->Zoom = yyvsp[-1].floating;
			}
    break;

  case 34:
#line 451 "parse_y.y"
    {
				yyPCB->IsleArea = yyvsp[-1].floating;
			}
    break;

  case 36:
#line 475 "parse_y.y"
    {
				yyPCB->ThermScale = yyvsp[-1].floating;
			}
    break;

  case 41:
#line 514 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-3].number;
				yyPCB->Shrink = yyvsp[-2].number;
				yyPCB->minWid = yyvsp[-1].number;
			}
    break;

  case 42:
#line 523 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-4].number;
				yyPCB->Shrink = yyvsp[-3].number;
				yyPCB->minWid = yyvsp[-2].number;
				yyPCB->minSlk = yyvsp[-1].number;
			}
    break;

  case 43:
#line 533 "parse_y.y"
    {
				yyPCB->Bloat = yyvsp[-6].number;
				yyPCB->Shrink = yyvsp[-5].number;
				yyPCB->minWid = yyvsp[-4].number;
				yyPCB->minSlk = yyvsp[-3].number;
				yyPCB->minDrill = yyvsp[-2].number;
				yyPCB->minRing = yyvsp[-1].number;
			}
    break;

  case 44:
#line 560 "parse_y.y"
    {
				yyPCB->Flags = MakeFlags (yyvsp[-1].number & PCB_FLAGS);
			}
    break;

  case 45:
#line 564 "parse_y.y"
    {
			  yyPCB->Flags = string_to_pcbflags (yyvsp[-1].string, yyerror);
			}
    break;

  case 47:
#line 596 "parse_y.y"
    {
			  layer_group_string = yyvsp[-1].string;
			}
    break;

  case 49:
#line 644 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 100))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 50:
#line 652 "parse_y.y"
    {
				if (ParseRouteString(yyvsp[-1].string, &yyPCB->RouteStyle[0], 1))
				{
					Message("illegal route-style string\n");
					YYABORT;
				}
			}
    break;

  case 57:
#line 674 "parse_y.y"
    { attr_list = & yyPCB->Attributes; }
    break;

  case 61:
#line 678 "parse_y.y"
    {
					/* clear pointer to force memory allocation by 
					 * the appropriate subroutine
					 */
				yyElement = NULL;
			}
    break;

  case 63:
#line 685 "parse_y.y"
    { YYABORT; }
    break;

  case 69:
#line 730 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 70:
#line 739 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].string,
					OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 71:
#line 750 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
					     (yyvsp[-5].number + yyvsp[-4].number)*100, yyvsp[-3].number*100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 72:
#line 760 "parse_y.y"
    {
				CreateNewVia(yyData, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100,  yyvsp[-3].number*100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 73:
#line 770 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				CreateNewVia(yyData, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 74:
#line 806 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, yyvsp[-1].flagtype);
			}
    break;

  case 75:
#line 811 "parse_y.y"
    {
				CreateNewRat(yyData, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-5].number, yyvsp[-2].number,
					Settings.RatThickness, OldFlags(yyvsp[-1].number));
			}
    break;

  case 76:
#line 842 "parse_y.y"
    {
				if (yyvsp[-4].number <= 0 || yyvsp[-4].number > MAX_LAYER + 2)
				{
					yyerror("Layernumber out of range");
					YYABORT;
				}
				if (LayerFlag[yyvsp[-4].number-1])
				{
					yyerror("Layernumber used twice");
					YYABORT;
				}
				Layer = &yyData->Layer[yyvsp[-4].number-1];

					/* memory for name is already allocated */
				Layer->Name = yyvsp[-3].string;
				LayerFlag[yyvsp[-4].number-1] = True;
				if (yyData->LayerN + 2 < yyvsp[-4].number)
				  yyData->LayerN = yyvsp[-4].number - 2;
			}
    break;

  case 88:
#line 883 "parse_y.y"
    {
				CreateNewPolygonFromRectangle(Layer,
					yyvsp[-5].number*100, yyvsp[-4].number*100, (yyvsp[-5].number+yyvsp[-3].number)*100, (yyvsp[-4].number+yyvsp[-2].number)*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 92:
#line 892 "parse_y.y"
    {
				Polygon = CreateNewPolygon(Layer, yyvsp[-2].flagtype);
			}
    break;

  case 93:
#line 896 "parse_y.y"
    {
					/* ignore junk */
				if (Polygon->PointN >= 3)
				  {
				    SetPolygonBoundingBox (Polygon);
				    if (!Layer->polygon_tree)
				      Layer->polygon_tree = r_create_tree (NULL, 0, 0);
				    r_insert_entry (Layer->polygon_tree, (BoxType *) Polygon, 0);
				  }
				else
				{
					Message("WARNING parsing file '%s'\n"
						"    line:        %i\n"
						"    description: 'ignored polygon (< 3 points)'\n",
						yyfilename, yylineno);
					DestroyObject(yyData, POLYGON_TYPE, Layer, Polygon, Polygon);
				}
			}
    break;

  case 94:
#line 945 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].flagtype);
			}
    break;

  case 95:
#line 953 "parse_y.y"
    {
				CreateNewLineOnLayer(Layer, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
						     yyvsp[-3].number*100, yyvsp[-2].number*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 96:
#line 962 "parse_y.y"
    {
				/* eliminate old-style rat-lines */
			if ((yyvsp[-1].number & RATFLAG) == 0)
				CreateNewLineOnLayer(Layer, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100,
					200*GROUNDPLANEFRAME, OldFlags(yyvsp[-1].number));
			}
    break;

  case 97:
#line 1010 "parse_y.y"
    {
			  CreateNewArcOnLayer(Layer, yyvsp[-9].number, yyvsp[-8].number, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-1].flagtype);
			}
    break;

  case 98:
#line 1018 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-9].number*100, yyvsp[-8].number*100, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-3].number, yyvsp[-2].number,
						    yyvsp[-5].number*100, yyvsp[-4].number*100, OldFlags(yyvsp[-1].number));
			}
    break;

  case 99:
#line 1027 "parse_y.y"
    {
				CreateNewArcOnLayer(Layer, yyvsp[-8].number*100, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-6].number*100, yyvsp[-3].number, yyvsp[-2].number,
					yyvsp[-4].number*100, 200*GROUNDPLANEFRAME, OldFlags(yyvsp[-1].number));
			}
    break;

  case 100:
#line 1064 "parse_y.y"
    {
					/* use a default scale of 100% */
				CreateNewText(Layer,yyFont,yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, 100, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 101:
#line 1074 "parse_y.y"
    {
				if (yyvsp[-1].number & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[yyData->LayerN +
						((yyvsp[-1].number & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay ,yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
						      OldFlags(yyvsp[-1].number));
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string,
						      OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 102:
#line 1092 "parse_y.y"
    {
				/* FIXME: shouldn't know about .f */
				/* I don't think this matters because anything with hi_format
				 * will have the silk on its own layer in the file rather
				 * than using the ONSILKFLAG and having it in a copper layer.
				 * Thus there is no need for anything besides the 'else'
				 * part of this code.
				 */
				if (yyvsp[-1].flagtype.f & ONSILKFLAG)
				{
					LayerTypePtr lay = &yyData->Layer[yyData->LayerN +
						((yyvsp[-1].flagtype.f & ONSOLDERFLAG) ? SOLDER_LAYER : COMPONENT_LAYER)];

					CreateNewText(lay, yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				}
				else
					CreateNewText(Layer, yyFont, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 105:
#line 1139 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 106:
#line 1143 "parse_y.y"
    {
				CreateNewPointInPolygon(Polygon, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 113:
#line 1215 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, NoFlags(),
					yyvsp[-6].string, yyvsp[-5].string, NULL, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number, 100, NoFlags(), False);
				SaveFree(yyvsp[-6].string);
				SaveFree(yyvsp[-5].string);
				pin_num = 1;
			}
    break;

  case 114:
#line 1223 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 115:
#line 1233 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-9].number),
					yyvsp[-8].string, yyvsp[-7].string, NULL, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 116:
#line 1241 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 117:
#line 1251 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-10].number),
					yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				SaveFree(yyvsp[-9].string);
				SaveFree(yyvsp[-8].string);
				SaveFree(yyvsp[-7].string);
				pin_num = 1;
			}
    break;

  case 118:
#line 1260 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 119:
#line 1271 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, OldFlags(yyvsp[-12].number),
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number)*100, (yyvsp[-7].number+yyvsp[-5].number)*100, yyvsp[-4].number, yyvsp[-3].number, OldFlags(yyvsp[-2].number), False);
				yyElement->MarkX = yyvsp[-8].number*100;
				yyElement->MarkY = yyvsp[-7].number*100;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 120:
#line 1281 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 121:
#line 1292 "parse_y.y"
    {
				yyElement = CreateNewElement(yyData, yyElement, yyFont, yyvsp[-12].flagtype,
					yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, (yyvsp[-8].number+yyvsp[-6].number), (yyvsp[-7].number+yyvsp[-5].number), yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].flagtype, False);
				yyElement->MarkX = yyvsp[-8].number;
				yyElement->MarkY = yyvsp[-7].number;
				SaveFree(yyvsp[-11].string);
				SaveFree(yyvsp[-10].string);
				SaveFree(yyvsp[-9].string);
			}
    break;

  case 122:
#line 1302 "parse_y.y"
    {
				SetElementBoundingBox(yyData, yyElement, yyFont);
			}
    break;

  case 130:
#line 1382 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 131:
#line 1387 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 132:
#line 1392 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 133:
#line 1397 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 134:
#line 1402 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number;
				yyElement->MarkY = yyvsp[-1].number;
			}
    break;

  case 135:
#line 1407 "parse_y.y"
    {
				yyElement->MarkX = yyvsp[-2].number*100;
				yyElement->MarkY = yyvsp[-1].number*100;
			}
    break;

  case 136:
#line 1411 "parse_y.y"
    { attr_list = & yyElement->Attributes; }
    break;

  case 144:
#line 1426 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number + yyElement->MarkX,
					yyvsp[-4].number + yyElement->MarkY, yyvsp[-3].number + yyElement->MarkX,
					yyvsp[-2].number + yyElement->MarkY, yyvsp[-1].number);
			}
    break;

  case 145:
#line 1432 "parse_y.y"
    {
				CreateNewLineInElement(yyElement, yyvsp[-5].number*100 + yyElement->MarkX,
					yyvsp[-4].number*100 + yyElement->MarkY, yyvsp[-3].number*100 + yyElement->MarkX,
					yyvsp[-2].number*100 + yyElement->MarkY, yyvsp[-1].number*100);
			}
    break;

  case 146:
#line 1439 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number + yyElement->MarkX,
					yyvsp[-6].number + yyElement->MarkY, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 147:
#line 1444 "parse_y.y"
    {
				CreateNewArcInElement(yyElement, yyvsp[-7].number*100 + yyElement->MarkX,
					yyvsp[-6].number*100 + yyElement->MarkY, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number*100);
			}
    break;

  case 148:
#line 1448 "parse_y.y"
    { attr_list = & yyElement->Attributes; }
    break;

  case 150:
#line 1490 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number + yyElement->MarkX,
					yyvsp[-8].number + yyElement->MarkY, yyvsp[-7].number, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].string,
					yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 151:
#line 1502 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-9].number*100 + yyElement->MarkX,
					yyvsp[-8].number*100 + yyElement->MarkY, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].string,
					yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 152:
#line 1514 "parse_y.y"
    {
				CreateNewPin(yyElement, yyvsp[-7].number*100, yyvsp[-6].number*100, yyvsp[-5].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-5].number + 2*MASKFRAME)*100, yyvsp[-4].number*100, yyvsp[-3].string, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 153:
#line 1525 "parse_y.y"
    {
				char	p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].number*100, yyvsp[-2].string, p_number, OldFlags(yyvsp[-1].number));

				SaveFree(yyvsp[-2].string);
			}
    break;

  case 154:
#line 1541 "parse_y.y"
    {
				BDimension	hole = (yyvsp[-3].number *DEFAULT_DRILLINGHOLE);
				char		p_number[8];

					/* make sure that there's enough copper left */
				if (yyvsp[-3].number -hole < MIN_PINORVIACOPPER && 
					yyvsp[-3].number > MIN_PINORVIACOPPER)
					hole = yyvsp[-3].number -MIN_PINORVIACOPPER;

				sprintf(p_number, "%d", pin_num++);
				CreateNewPin(yyElement, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, hole, yyvsp[-2].string, p_number, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 155:
#line 1595 "parse_y.y"
    {
				CreateNewPad(yyElement, yyvsp[-10].number + yyElement->MarkX,
					yyvsp[-9].number + yyElement->MarkY,
					yyvsp[-8].number + yyElement->MarkX,
					yyvsp[-7].number + yyElement->MarkY, yyvsp[-6].number, yyvsp[-5].number, yyvsp[-4].number,
					yyvsp[-3].string, yyvsp[-2].string, yyvsp[-1].flagtype);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 156:
#line 1609 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-10].number*100 + yyElement->MarkX,
					yyvsp[-9].number*100 + yyElement->MarkY, yyvsp[-8].number*100 + yyElement->MarkX,
					yyvsp[-7].number*100 + yyElement->MarkY, yyvsp[-6].number*100, yyvsp[-5].number*100, yyvsp[-4].number*100,
					yyvsp[-3].string, yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 157:
#line 1622 "parse_y.y"
    {
				CreateNewPad(yyElement,yyvsp[-8].number*100,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-4].number + 2*MASKFRAME)*100, yyvsp[-3].string,yyvsp[-2].string, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 158:
#line 1633 "parse_y.y"
    {
				char		p_number[8];

				sprintf(p_number, "%d", pin_num++);
				CreateNewPad(yyElement,yyvsp[-7].number*100,yyvsp[-6].number*100,yyvsp[-5].number*100,yyvsp[-4].number*100,yyvsp[-3].number*100, 200*GROUNDPLANEFRAME,
					(yyvsp[-3].number + 2*MASKFRAME)*100, yyvsp[-2].string,p_number, OldFlags(yyvsp[-1].number));
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 159:
#line 1643 "parse_y.y"
    { yyval.flagtype = OldFlags(yyvsp[0].number); }
    break;

  case 160:
#line 1644 "parse_y.y"
    { yyval.flagtype = string_to_flags (yyvsp[0].string, yyerror); }
    break;

  case 163:
#line 1673 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number;
			}
    break;

  case 165:
#line 1690 "parse_y.y"
    {
				if (yyvsp[-3].number <= 0 || yyvsp[-3].number > MAX_FONTPOSITION)
				{
					yyerror("fontposition out of range");
					YYABORT;
				}
				Symbol = &yyFont->Symbol[yyvsp[-3].number];
				if (Symbol->Valid)
				{
					yyerror("symbol ID used twice");
					YYABORT;
				}
				Symbol->Valid = True;
				Symbol->Delta = yyvsp[-2].number*100;
			}
    break;

  case 174:
#line 1743 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number*100, yyvsp[-4].number*100, yyvsp[-3].number*100, yyvsp[-2].number*100, yyvsp[-1].number*100);
			}
    break;

  case 175:
#line 1750 "parse_y.y"
    {
				CreateNewLineInSymbol(Symbol, yyvsp[-5].number, yyvsp[-4].number, yyvsp[-3].number, yyvsp[-2].number, yyvsp[-1].number);
			}
    break;

  case 183:
#line 1804 "parse_y.y"
    {
				Menu = CreateNewNet(&yyPCB->NetlistLib, yyvsp[-3].string, yyvsp[-2].string);
				SaveFree(yyvsp[-3].string);
				SaveFree(yyvsp[-2].string);
			}
    break;

  case 189:
#line 1839 "parse_y.y"
    {
				CreateNewConnection(Menu, yyvsp[-1].string);
				SaveFree(yyvsp[-1].string);
			}
    break;

  case 192:
#line 1872 "parse_y.y"
    {
				CreateNewAttribute (attr_list, yyvsp[-2].string, yyvsp[-1].string);
				SaveFree (yyvsp[-2].string);
				SaveFree (yyvsp[-1].string);
			}
    break;

  case 193:
#line 1879 "parse_y.y"
    { yyval.string = yyvsp[0].string; }
    break;

  case 194:
#line 1880 "parse_y.y"
    { yyval.string = 0; }
    break;


    }

/* Line 991 of yacc.c.  */
#line 2584 "../../pcb-head/src/parse_y.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  MacOS 10.2.3's buggy "smart preprocessor"
     insists on the trailing semicolon.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
  __attribute__ ((__unused__));
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1883 "parse_y.y"


/* ---------------------------------------------------------------------------
 * error routine called by parser library
 */
int yyerror(s)
const char *s;
{
	Message("ERROR parsing file '%s'\n"
		"    line:        %i\n"
		"    description: '%s'\n",
		yyfilename, yylineno, s);
	return(0);
}

int yywrap()
{
  return 1;
}


static int
check_file_version (int ver)
{
  if ( ver > PCB_FILE_VERSION ) {
    Message ("ERROR:  The file you are attempting to load is in a format\n"
	     "which is too new for this version of pcb.  To load this file\n"
	     "you need a version of pcb which is >= %d.  If you are\n"
	     "using a version built from cvs sources, the source date\n"
	     "must be >= %d.  This copy of pcb can only read files\n"
	     "up to file version %d.\n", ver, ver, PCB_FILE_VERSION);
    return 1;
  }
  
  return 0;
}


