/* $Id: scanner.h,v 1.14 2004/09/29 03:53:58 igor Exp $ */

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __SCANNER_H__
#define __SCANNER_H__

/* Definitions for lex & yacc */
#define yywrap() 1

/* XXX: DO NOT CHAGE THE ORDER! WE DEPEND ON IT WHILE PARSING THE INDEX FILE! */
typedef enum
{
	P_DISTRIBNAME,
	P_PORTPATH,
	P_INSTALLPREFIX,
	P_COMMENT,
	P_DESCFILE,
	P_MAINTAINER,
	P_CATEGORY,
#ifdef __OpenBSD__
	P_LIBDEPS,
#endif	/* __OpenBSD__ */	
	P_BUILDDEPS,
	P_RUNDEPS,
#ifndef __OpenBSD__
	P_WWW,
#else
	P_FORARCH,
	P_PACKAGECDROM,
	P_PACKAGEFTP,
	P_DISTFILESCDROM,
	P_DISTFILESFTP,
	P_FLAVOUR,
	P_MULTIPACKAGE,
#endif
	PN_ENTRIES
} PkgFieldPosition;


/*  PROTOTYPES  */
/* gram.y */
__BEGIN_DECLS
Boolean	 parse_index(char *);
__END_DECLS

#endif /* __SCANNER_H__*/
