/* $Id: scan.l,v 1.7 2004/10/20 07:16:10 igor Exp $ */

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


%{
#include <string.h>

#include "y.tab.h"
#include "macros.h"
#include "scanner.h"

/* PROTOTYPES */
int      yylex(void);

#define YYSTYPE char *
extern YYSTYPE yylval;

%}

PATH    	[A-Za-z_0-9]*[./][-A-Za-z_0-9./]*
WORD    	[A-Za-z_][-A-Za-z_0-9]*

BRACES		[()[\]{}]
PUNCT		[?!,.;:'`]
MATH		[<=>*+-]
OTHER		[@$%\^&\/~#_]
SPACES		[ \t\n]

ANY		[^\|\n]

DELIMETER	\|
NEWLINE		\n

%%


{ANY}+ 			{ yylval=strdup(yytext); return SIMPLEWORD; }
{DELIMETER}		{ return DELIM; }
{NEWLINE}		{ return EOL; }
<<EOF>>			{ return YY_NULL; }

%%
