/* $Id: pkgobject.h,v 1.7 2004/11/10 09:25:59 igor Exp $*/

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


#ifndef __PKGOBJECT_H__
#define __PKGOBJECT_H__

#ifndef __OpenBSD__
#include <sys/param.h>
#endif

#include <sys/queue.h>

#include <glib.h>
#include <glib-object.h>

#include "pkgquery.h"

#define PORTS_DIR	"/usr/ports/"		/* standard place for the ports dir */

#if (defined __FreeBSD__) && (__FreeBSD_version >= 500036)
#define INDEXFILE	PORTS_DIR"INDEX-5"  /* this is kind of weird but thats the way it's done on FreeBSD */
#else
#define INDEXFILE	PORTS_DIR"INDEX"    /* where is the INDEX File located? */
#endif

#ifdef __OpenBSD__
#define	PLISTFILE	"/pkg/PLIST"
#else
#define PLISTFILE	"/pkg-plist"
#endif

#define DBDIR		"/var/db/pkg/"		 /* info on installed pkgs */


#define TYPE_PKGOBJECT			(pkgobject_get_type())
#define PKGOBJECT(obj)  		(G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_PKGOBJECT, PkgObject))
#define PKGOBJECT_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TYPE_PKGOBJECT, PkgObjectClass))
#define IS_PKGOBJECT(obj) 		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_PKGOBJECT))
#define IS_PKGOBJECT_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_PKGOBJECT))
#define PKGOBJECT_GET_CLASS(obj)  	(G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_PKGOBJECT, PkgObjectClass))


typedef struct _PkgObject 	PkgObject;
typedef struct _PkgObjectClass	PkgObjectClass;

/* PkgObject Attributes */
struct _PkgObject
{
	GObject	 g_object_instance;		
	LIST_ENTRY(_PkgObject) next;	/* LIST GLUE				*/		
	unsigned int ID;		/* UNIQUE ID per package	   	*/	
	Boolean install_status;		/* indicating if pkg is installed  	*/
	char *distrib_name;		/* distribution-name               	*/
        char *port_path;                /* port-path                       	*/
        char *install_prefix;           /* installation-prefix             	*/    
        char *comment;                 	/* comment                         	*/
        char *descr_file;            	/* description file                	*/
        char *maintainer;               /* package maintainer              	*/
        char *category;                 /* category                        	*/
	char *bdep;	            	/* build dependencies              	*/
        char *rdep;              	/* run dependencies                	*/
#ifdef __OpenBSD__
	char *ldep;              	/* library dependencies            	*/
	char *forarch;
	char *cdrom;
	char *ftp;
	char *distcdrom;
	char *distftp;
	char *flav;			/* ARE WE FLAVOURED ?		   	*/
	char *multi;			/* ARE WE MULTIPACKAGED ?	   	*/
#else
	char *www;			/* port homepage			*/
#endif 	
};

/* PkgObject Methods */
struct _PkgObjectClass
{
	GObjectClass	g_object_class;
};

/* PROTOTYPES */
__BEGIN_DECLS
/* pkgobject.c */
GType		 pkgobject_get_type(void) G_GNUC_CONST;
PkgObject	*pkgobject_clone(PkgObject *);
/* Getter|Setter functions */
unsigned int	 pkgobject_get_id(PkgObject *);
Boolean	 	 pkgobject_get_install_status(PkgObject *);
Boolean	 	 pkgobject_get_descr_content(PkgObject *, char *, size_t);
Boolean	 	 pkgobject_get_plist_content(PkgObject *, char *, size_t);
char		*pkgobject_get_distrib_name(PkgObject *);
char		*pkgobject_get_port_path(PkgObject *);
char		*pkgobject_get_install_prefix(PkgObject *);
char		*pkgobject_get_comment(PkgObject *);
char		*pkgobject_get_maintainer(PkgObject *);
char		*pkgobject_get_category(PkgObject *);
char		*pkgobject_get_build_depends(PkgObject *);
char		*pkgobject_get_run_depends(PkgObject *);
char		*pkgobject_get_descr_path(PkgObject *);
void	 	 pkgobject_set_install_status(PkgObject *, Boolean);
void	 	 pkgobject_set_id(PkgObject *, unsigned int);
void	 	 pkgobject_set_distrib_name(PkgObject *, const char *);
void	 	 pkgobject_set_port_path(PkgObject *, const char *);
void	 	 pkgobject_set_install_prefix(PkgObject *, const char *);
void	 	 pkgobject_set_comment(PkgObject *, const char *);
void	 	 pkgobject_set_maintainer(PkgObject *, const char *);
void	 	 pkgobject_set_category(PkgObject *, const char *);
void	 	 pkgobject_set_build_depends(PkgObject *, const char *);
void	 	 pkgobject_set_run_depends(PkgObject *, const char *);
void	 	 pkgobject_set_descr_path(PkgObject *, const char *);
/* Free|OpenBSD specific stuff */
#ifdef __OpenBSD__
char		*pkgobject_get_library_depends(PkgObject *);
char		*pkgobject_get_forarch(PkgObject *);
char		*pkgobject_get_cdrom(PkgObject *);
char		*pkgobject_get_ftp(PkgObject *);
char		*pkgobject_get_distfiles_cdrom(PkgObject *);
char		*pkgobject_get_distfiles_ftp(PkgObject *);
char		*pkgobject_get_flavour(PkgObject *);
char		*pkgobject_get_multipackage(PkgObject *);
void	 	 pkgobject_set_library_depends(PkgObject *, const char *);
void	 	 pkgobject_set_forarch(PkgObject *, const char *);
void	 	 pkgobject_set_cdrom(PkgObject *, const char *);
void	 	 pkgobject_set_ftp(PkgObject *, const char *);
void	 	 pkgobject_set_distfiles_cdrom(PkgObject *, const char *);
void	 	 pkgobject_set_distfiles_ftp(PkgObject *, const char *);
void	 	 pkgobject_set_flavour(PkgObject *, const char *);
void	 	 pkgobject_set_multipackage(PkgObject *, const char *);
#else
char		*pkgobject_get_homepage(PkgObject *);
void	 	 pkgobject_set_homepage(PkgObject *, const char *);
#endif
/* list functions */
Boolean		 pkgobject_is_list_empty(void);
PkgObject 	*pkgobject_get_list_head(void);
void		 pkgobject_destroy_list(void);
void		 pkgobject_create_list(size_t);
size_t		 pkgobject_get_list_size(void);
PkgObject	*pkgobject_get_list_next(PkgObject *);
void		 pkgobject_list_insert_head(PkgObject *obj);
void		 pkgobject_list_insert_after(PkgObject *obj1, PkgObject *obj2);
/* other stuff */
void		 pkgobject_increment_installed_packages(void);
void		 pkgobject_decrement_installed_packages(void);
size_t		 pkgobject_get_number_installed_packages(void);
Boolean		 pkgobject_parse_package_list(void);
Boolean	 	 pkgobject_check_install_status(PkgObject *);
size_t	 	 pkgobject_execute_query(PkgObject *, PkgQuery *);
void	 	 pkgobject_print(PkgObject *);
__END_DECLS

#endif /* __PKGOBJECT_H__ */
