/* $Id: pkgcmd.h,v 1.13 2004/11/14 18:29:25 igor Exp $$*/

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


#ifndef __PKGCMD_H__
#define __PKGCMD_H__

#ifndef __OpenBSD__
#include <sys/param.h>
#endif

#ifdef __OpenBSD__
#define	DEFAULT_URI "ftp://ftp.openbsd.org:21/pub/OpenBSD/"__OSREV__"/packages/"__ARCH__"/"
#else
#define	DEFAULT_URI "ftp://ftp.freebsd.org/pub/FreeBSD/ports/"__ARCH__"/packages-"__OSREL__"/"
#endif
 
#define	SU_BIN 		"/usr/bin/su"
#define KILL_BIN	"/bin/kill"
#ifdef __OpenBSD__
#define SUDO_BIN        "/usr/bin/sudo"
#else
#define SUDO_BIN        "/usr/local/bin/sudo"
#endif

/* DEFINE PKG|PORT MANIPULATION COMMANDS */
#define PKG_ADD		"/usr/sbin/pkg_add -v "
#define PKG_DELE	"/usr/sbin/pkg_delete -v "
#define PKG_DELE_FORCE	"/usr/sbin/pkg_delete -v -f dependencies "

/* SINCE FREEBSD 5.x THEY USE BZIP */
#if (defined __FreeBSD__) && (__FreeBSD_version >= 500000)
#define SUFFIX	".tbz"
#else
#define SUFFIX	".tgz"
#endif

/* 
 * IF THE PSEUDO-TTY IS ASKING FOR A TERMINAL TYPE BECAUSE OF TSET
 * WHICH IS BEING CALLED, THIS IS THE TERMINAL WHICH WILL BE CHOSEN.
 */
#define	TERM_TYPE	"vt220"

typedef enum
{
	PB_PKGCMD_INST_PORT,
	PB_PKGCMD_INST_PKG,
	PB_PKGCMD_DEL_PKG,
	PB_PKGCMD_DELF_PKG
} PkgCmdInstallType;

typedef enum
{
	PB_PKGCMD_ERROR_FORK,
	PB_PKGCMD_ERROR_READ_FD,
	PB_PKGCMD_ERROR_READ_PIPE,
	PB_PKGCMD_ERROR_TERM,
	PB_PKGCMD_ERROR_AUTH,
	PB_PKGCMD_ERROR_PKG_UNAVAILABLE,
	PB_PKGCMD_ERROR_PKG_CONFLICT,
	PB_PKGCMD_ERROR_ACQUIRE_MUTEX,
	PB_PKGCMD_ERROR_PERM
} PkgCmdError;		

typedef struct _InstallParams InstallParams;

struct _InstallParams
{
	PkgCmdInstallType	inst_type;		
	PkgObject		*pkg;
	GError			*err;		
};

/* PROTOTYPES */
__BEGIN_DECLS
/* pkgcmd.c */
void	 pb_root_pwd_set(const char *);
void	 pb_root_pwd_clear(void);
Boolean	 pb_root_pwd_is_valid(void);
void	 pb_auth_once_set(Boolean);
void	 pb_auth_use_sudo(Boolean);
Boolean	 pb_auth_type_is_sudo(void);
void	 pb_pkg_path_set(const char *);
void	 pb_pkg_path_get(char **);
void	 pkg_stop_operation(int);
Boolean	 pkg_perform_operation(InstallParams *);
void	 pb_grep_process_output(char **);
void	 pb_clear_process_output(void);
__END_DECLS

#endif /* __PKGCMD_H__ */
