/* $Id: macros.h,v 1.13 2004/10/18 12:08:56 igor Exp $*/

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __MACROS_H__
#define __MACROS_H__

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif

#define IS_NULL(ptr) (!ptr)

#define FREE(ptr) if (ptr) {	\
	free(ptr);	\
	ptr = NULL;	\
	}

#define FREE_PATH(path) if (path) {	\
	gtk_tree_path_free(path);	\
	path = NULL;			\
	}

/* GENERAL USEFUL TYPES */
typedef int Boolean;

#ifndef MAXBSIZE
#define MAXBSIZE    (64 * 1024)
#endif

#ifndef BUFSIZ
#define BUFSIZ 1024
#endif

#endif /* __MACROS_H__ */
