/* $Id: interface.h,v 1.21 2004/11/13 12:42:10 igor Exp $ */

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __INTERFACE_H__
#define __INTERFACE_H__

#define WINDOWHEIGHT 600

#ifdef __OpenBSD__
#define WINTITLE "OpenBSD - Ports Browser " PBVERSION
#else
#define WINTITLE "FreeBSD - Ports Browser " PBVERSION
#endif

typedef struct _PBWindow	PBWindow;
typedef struct _PBSearchWindow 	PBSearchWindow;

/* PBBrowser Window */
struct _PBWindow
{
	/* Main Window */
	GtkWidget	*main_window;
	/* Search Window */
	PBSearchWindow	*search_window;
	/* Boolean -> indicating if search window is active */
	Boolean		 search_active;		
	/* Scrolled Window holding TreeView */
	GtkWidget	*scr_win_tree;
	/* Toolbar Stock Items */
	GtkWidget	*t_forward, *t_backward;		
	GtkWidget	*t_find, *t_refresh;
	/* GtkButtons */
	GtkWidget	*b_iport, *b_ipkg;
       GtkWidget	*b_dpkg, *b_dpkgf;		
	/* GtkHbox, GtkVbox, GtkHpaned */
	GtkWidget	*vbox_notebook;		
	/* Various other elements */
	GtkStatusbar	*statusbar;
	GtkToolbar	*toolbar;
	/* Accelerator Group for this window */
	GtkAccelGroup	*accel_group;
	/* GtkEntry */
	GtkEntry 	*e_name, *e_cat;
	GtkEntry	*e_sdesc, *e_dir;
	/* GtkTextView */
	GtkTextView	*txtv_ldesc, *txtv_plist;
	GtkTextView	*txtv_bdep, *txtv_rdep;
	/* GtkTextBuffer */
	GtkTextBuffer  	*txtb_bdep, *txtb_ldesc;
	GtkTextBuffer  	*txtb_plist, *txtb_rdep;
#ifdef __OpenBSD__
	GtkTextBuffer  	*txtb_ldep;
	GtkEntry 	*e_multi, *e_flav;
	GtkTextView	*txtv_ldep;
#else
	GtkEntry	*e_www;		
#endif
};

/* PBrowser Search Window */
struct _PBSearchWindow
{
	/* Main Search Window */
	GtkWidget	*search_window;
	/* Current search query */
	PkgQuery	*cur_query;
	/* GtkTreePath to a previously found PkgBase element */
	GtkTreePath	*old_path;
	/* GtkToggleButton */
	GtkWidget	*tog_case;		
	/* GtkButton */
	GtkButton 	*b_search, *b_close, *b_clear;
	/* GtkEntry */
	GtkEntry	*entry;
	/* GtkOptionMenu */
	GtkOptionMenu	*omenu;		
};
		
enum
{
	INT_COL_ID,
	STRING_COL_CATEGORY,
	STRING_COL_PKGNAME,
	BOOL_COL_INSTALL,
	N_COLUMNS
};

/* PROTOTYPES */
__BEGIN_DECLS
/* interface.c */
void		 create_treeview(PBWindow *);
GtkWidget	*create_main_window(PBWindow *);
__END_DECLS

#endif /* __INTERFACE_H__ */
