/* $Id: gtkutil.h,v 1.8 2004/11/13 12:42:10 igor Exp $ */

/*
 * Copyright (c) 2004 Igor Boehm <igor@bytelabs.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF MIND, USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __GTKUTIL_H__
#define __GTKUTIL_H__

#define LENSTATUSTEXT 256

/*
 * Possible selections from GtkOptionMenu which is created in
 * pb_create_search_window
 */
enum {
	MENU_SELECT_SALL,
	MENU_SELECT_PKGNAME,
	MENU_SELECT_COMMENT,
	MENU_SELECT_DESC,
	MENU_SELECT_RDEP,
#ifdef __OpenBSD__
	MENU_SELECT_LDEP,
#endif				/* __OpenBSD__ */
	MENU_SELECT_BDEP,
};

/* PROTOTYPES */
__BEGIN_DECLS
/* gtkutil.c */
GtkWidget      *pb_create_progressbar(GtkWidget *, GtkProgressBar **,
		      GtkTextView **, GtkButton **,
		      GtkButton **, char *, char *, char *);
GtkWidget      *pb_create_search_window(GtkWidget *, GtkEntry **, GtkWidget **,
			GtkButton **, GtkButton **, GtkButton **,
			GtkOptionMenu **, const char *);
GtkWidget      *pb_create_pwd_dialog(GtkWidget *);
GtkWidget      *pb_create_path_dialog(GtkWidget *);
GtkWidget      *pb_create_warning_dialog(GtkWidget *, const char *);
GtkWidget      *pb_create_custom_button(const char *, const char *);
GtkWidget      *pb_menu_shell_append(GtkMenu *, const char *, const char *,
		     GCallback, gpointer, GtkAccelGroup *, int);
Boolean         pb_set_statusbar_text(GtkStatusbar *, char *fmt,...);
gboolean        pb_update_progress(gpointer);
gboolean        pb_update_textview(gpointer);
__END_DECLS

#endif				/* __GTKUTIL_H__ */
