/*
 * $Id: passwdqc.h,v 1.1.1.1 2005/01/18 00:29:33 djm Exp $
 *
 * Copyright (c) 2000-2002 by Alexander Peslyak (Solar Designer)
 *
 * You're allowed to do whatever you like with this software (including
 * re-distribution in source and/or binary form, with or without
 * modification), provided that credit is given where it is due and any
 * modified versions are marked as such.  There's absolutely no warranty.
 * 
 * Note that you don't have to re-distribute this software under these
 * same relaxed terms.  In particular, you're free to place modified
 * versions under (L)GPL, thus disallowing further re-distribution in
 * binary-only form.
 *
 * NB. This version is modified for OpenBSD use
 */

#ifndef _PASSWDQC_H
#define _PASSWDQC_H

#include <pwd.h>

typedef struct {
	int min[5], max;
	int passphrase_words;
	int match_length;
	int similar_deny;
} passwdqc_params_t;

extern char _passwdqc_wordset_4k[0x1000][6];

extern const char *passwdqc_check(const passwdqc_params_t *params,
    const char *newpass, const char *oldpass, const struct passwd *pw);

#endif
