/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/17 17:29:31 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/rendertextrect.cpp,v $
    CVS/RCS Revision: $Revision: 1.21.2.4 $
    Status:           $State: Exp $
*/

#include "paragui.h"
#include <string.h>
#include "rendertextrect.h"
#include "pgdrawobject.h"
#include "pgapplication.h"

const char* findBreak(TTF_Font* font, int w, const char* start, const char* end);


const char** breakLines(int& numbreaks, TTF_Font* font, const PG_Rect& r, const char* text) {
	static const char* breaks[100];
	const char* b = text;
	const char* end = text + strlen(text) -1;		// last character in text

	int i=0;

	// check for all breaks
	while((b != end) && (b+1 != end)) {
		breaks[i] = b;

		b = findBreak(font, r.w, b, end);
		i++;
	}
	breaks[i] = end+1;

	numbreaks = i+1;
	return breaks;
}

const char* findBreak(TTF_Font* font, int w, const char* start, const char* end) {
	int tw,th;

	while((*start == ' ') || (*start == '\t'))
		start++;

	while((*end == ' ') || (*end == '\t') || (*end == 0x0A) || (*end == 0x0D)) {
		end--;
	}

	const char* temp = end;

	// first check if the whole string fits into the given width
	TTF_SizeText(font, start, &tw, &th);

	// does it fit ?
	if(tw > w) {

		// search for breaks (space, cr, lf)
		while((*temp != ' ')/* && (*temp != 0x0A) && (*temp != 0x0D)*/ && (temp != start)) {
			temp--;
		}

		// found a hard break ?
		if(*temp == 0x0D) {}

		// no space found ?
		if(temp == start) {
			temp = end--;
		}

		// length of part
		int l = (long)temp - (long)start;

		// copy part to new string
		//char* a = (char*)malloc((l+1) * sizeof(char));
		char* a = new char[l+1];
	
		strncpy(a, start, l);

		// terminate string
		a[l] = 0;

		// get width of strings
		TTF_SizeText(font, a, &tw, &th);

		// free strings
		delete[] a;

		// do the recursion
	
		if(tw > w) {			// width of string exceeds width limit
			return findBreak(font, w, start, temp);
		}
	}

	// check for a hard break
	while(start != temp) {
		if((*start == 0x0A) || (*start == 0x0D)) {
			temp = start;
			break;
		}
		start++;
	}

	while((*temp == ' ') || (*temp == 0x0A) || (*temp == 0x0D) || (*temp == '\t'))
		temp++;

	return temp;

}

void RenderTextRect(SDL_Surface* surface, TTF_Font* font, const PG_Rect& r, const char* text, SDL_Color fg, int align) {
	static char buffer[1000];
	int n;
	int y = r.y;
	SDL_Surface* srf_text = NULL;
	SDL_Rect src, dest;

	if(text == NULL) {
		return;
	}

	if(text[0] == 0) {
		return;
	}

	//SDL_DrawLine(surface, r->x, r->y, r->x, r->y+r->h, fg);
	//SDL_DrawLine(surface, r->x+r->w, r->y, r->x+r->w, r->y+r->h, fg);

	const char** breaks = breakLines(n, font, r, text);
	const char* line = NULL;

	for(int i=0; (i<(n-1)) && (y < (r.y + r.h)); i++) {
		line = breaks[i];

		int b=0;
		buffer[0] = 0;
		while(line != breaks[i+1]) {
			buffer[b++] = *line++;
			if(buffer[b-1] == '\t') {
				buffer[b-1] = ' ';
			}
		}
		buffer[b] = 0;

		b--;
		while((buffer[b] == ' ') || (buffer[b] == 0x0a) || (buffer[b] == 0x0D)) {
			buffer[b] = 0;
			b--;
		}

		if(buffer[0] == 0) {
			continue;
		}

		srf_text = PG_DrawObject::RenderText(font, buffer, fg);

		if(srf_text == NULL) {
			continue;
		}

		dest.y = y;
		dest.w = srf_text->w;
		dest.h = srf_text->h;

		switch(align) {

			case PG_TA_LEFT:
				dest.x = r.x;
				break;

			case PG_TA_CENTER:
				dest.x = r.x + (r.w - srf_text->w)/2;
				break;

			case PG_TA_RIGHT:
				dest.x = r.x + (r.w - srf_text->w);
				break;

		}

		src.x = 0;
		src.y = 0;
		src.w = srf_text->w;
		src.h = srf_text->h;
		
		PG_BlitSurface(srf_text, src, surface, dest);
		PG_UpdateRects(surface, 1, &dest);
		SDL_FreeSurface(srf_text);

		y += dest.h;
	}
}
