/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/09 18:28:12 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pgwindow.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.28 $
    Status:           $State: Exp $
*/

#include "pgwindow.h"
#include "pgapplication.h"
#include <string.h>

PG_Window::PG_Window(PG_Widget* parent, const PG_Rect& r, char* windowtext, bool modal, const char* style) : PG_StaticFrame(parent, r) {
		
	my_srfTitlebar = NULL;
	my_moveMode = false;
	my_heightTitlebar = 25;
	my_showCloseButton = true;

	my_gradientTitlebar.colors[0].r = 204;
	my_gradientTitlebar.colors[0].g = 204;
	my_gradientTitlebar.colors[0].b = 204;

	my_gradientTitlebar.colors[1].r = 102;
	my_gradientTitlebar.colors[1].g = 102;
	my_gradientTitlebar.colors[1].b = 120;

	my_gradientTitlebar.colors[2].r = 100;
	my_gradientTitlebar.colors[2].g = 100;
	my_gradientTitlebar.colors[2].b = 231;

	my_gradientTitlebar.colors[3].r = 50;
	my_gradientTitlebar.colors[3].g = 50;
	my_gradientTitlebar.colors[3].b = 115;

	my_colorTitlebar.r = 0xFF;
	my_colorTitlebar.g = 0xFF;
	my_colorTitlebar.b = 0xFF;

	my_backgroundTitlebar = NULL;
	my_backmodeTitlebar = BKMODE_TILE;
	my_blendTitlebar = 0;
	my_bordersizeTitlebar = 1;
		
	PG_Rect rb;
	my_buttonClose = new PG_Button(this, PG_WINDOW_CLOSE, rb, NULL);

	my_labelTitle = new PG_Label(this, PG_Rect(0, 0, my_width, my_heightTitlebar), windowtext, style);
	my_labelTitle->SetAlignment(PG_TA_CENTER);

	LoadThemeStyle(style);

	if(my_showCloseButton) {
		rb.SetRect(
			r.my_width - my_heightTitlebar,
			0,
			my_heightTitlebar,
			my_heightTitlebar);

		my_buttonClose->MoveWindow(rb.my_xpos, rb.my_ypos);
		my_buttonClose->SizeWindow(rb.my_width, rb.my_height);
	}
	else {
		delete my_buttonClose;
		my_buttonClose = NULL;
	}

	SizeWindow(r.my_width, r.my_height);
	bSetCaptureOnShow = modal;
}

PG_Window::~PG_Window() {
	if(my_srfTitlebar) {
		DeleteThemedSurface(my_srfTitlebar);
		my_srfTitlebar = NULL;
	}
}

void PG_Window::LoadThemeStyle(const char* widgettype) {
	PG_Theme* t = PG_Application::GetTheme();
	int b;

	PG_StaticFrame::LoadThemeStyle(widgettype, "Window");	
	
	PG_Gradient* g = t->FindGradient(widgettype, "Titlebar", "gradient");
	if(g) my_gradientTitlebar = *g;
	
	b = t->FindProperty(widgettype, "Titlebar", "height");
	if(b != -1) my_heightTitlebar = b;

	b = t->FindProperty(widgettype, "Titlebar", "bordersize");
	if(b != -1) my_bordersizeTitlebar = b;

	my_backgroundTitlebar = t->FindSurface(widgettype, "Titlebar", "background");
	
	b = t->FindProperty(widgettype, "Titlebar", "backmode");
	if(b != -1) my_backmodeTitlebar = b;

	b = t->FindProperty(widgettype, "Titlebar", "blend");
	if(b != -1) my_blendTitlebar = b;

	long c = t->FindProperty(widgettype, "Titlebar", "textcolor");
	if(c != -1) SetColorTitlebar(c);

	b = t->FindProperty(widgettype, "Titlebar", "showclosebutton");
	if(b != -1) my_showCloseButton = b? true : false;
	
	if(my_showCloseButton) {
		my_buttonClose->LoadThemeStyle(widgettype, "CloseButton");
	}

	PG_GradientWidget::LoadThemeStyle(widgettype);	
}

void PG_Window::eventSizeWindow(int w, int h) {
	my_rectTitlebar.SetRect(0, 0, 0,my_heightTitlebar);

	if(my_buttonClose) {
		my_rectTitlebar.my_width = w - my_heightTitlebar;
		my_buttonClose->MoveWindow(w-my_heightTitlebar, 0);
	}
	else {
		my_rectTitlebar.my_width = w;
	}

	if(my_srfTitlebar) {
		DeleteThemedSurface(my_srfTitlebar);
	}
	
	my_srfTitlebar = CreateThemedSurface(
						my_rectTitlebar,
						&my_gradientTitlebar,
						my_backgroundTitlebar,
						my_backmodeTitlebar,
						my_blendTitlebar);

	my_labelTitle->SizeWindow(my_rectTitlebar.w, my_rectTitlebar.h);

	PG_StaticFrame::eventSizeWindow(w, h);
}

void PG_Window::eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst) {
	PG_Rect my_src;
	PG_Rect my_dst;

	PG_StaticFrame::eventBlit(srf, src, dst);

	if(my_srfTitlebar != NULL) {
		PG_Rect r(
		my_xpos + my_rectTitlebar.my_xpos,
		my_ypos + my_rectTitlebar.my_ypos,
		my_rectTitlebar.my_width,
		my_rectTitlebar.my_height);

		GetClipRects(my_src, my_dst, r);
		PG_BlitSurface(my_srfTitlebar, my_src, my_srfScreen, my_dst);
		//PG_DrawObject::eventBlit(my_srfTitlebar, my_src, my_dst);
	}

	PG_Rect client(0, 0, my_rectTitlebar.my_width, my_rectTitlebar.my_height);

	// draw border for titlebar
	DrawBorder(client, my_bordersizeTitlebar);

	// draw border for window
	client.my_ypos += my_rectTitlebar.my_height;
	client.my_width = my_width;
	client.my_height = my_height - my_rectTitlebar.my_height;

	DrawBorder(client, my_bordersize);

	client.my_xpos++;
	client.my_ypos++;
	client.my_width -= 2;
	client.my_height -= 2;

	DrawBorder(client, my_bordersize, false);
}

bool PG_Window::eventMouseButtonDown(const SDL_MouseButtonEvent* button) {
	PG_Rect ta(*this);
	ta.my_width = my_rectTitlebar.my_width;
	ta.my_height = my_rectTitlebar.my_height;

	int x,y;
	x = button->x;
	y = button->y;

	if((ta.my_xpos <= x) && (x <= ta.my_xpos + ta.my_width)) {
		if((ta.my_ypos <= y) && (y <= ta.my_ypos + ta.my_height)) {
			my_moveMode = true;
			my_moveDelta.x = ta.my_xpos - x;
			my_moveDelta.y = ta.my_ypos - y;
			Show();
			SetCapture();
			return true;
		}
	}

	return PG_Widget::eventMouseButtonDown(button);
}

bool PG_Window::eventMouseButtonUp(const SDL_MouseButtonEvent* button) {
	int x,y;

	x = button->x;
	y = button->y;

	x += my_moveDelta.x;
	y += my_moveDelta.y;

	if(x < 0) x=0;
	if(y < 0) y=0;
	if(x > (my_srfScreen->w - my_width - 1)) x = (my_srfScreen->w - my_width - 1);
	if(y > (my_srfScreen->h - my_height - 1)) y = (my_srfScreen->h - my_height -1);

	if(my_moveMode) {
		my_moveMode = false;
		if(!bSetCaptureOnShow) {
			ReleaseCapture();
		}
		return true;
	}

	return PG_Widget::eventMouseButtonUp(button);
}

bool PG_Window::eventMouseMotion(const SDL_MouseMotionEvent* motion) {
	if(!my_moveMode) {
		return PG_Widget::eventMouseMotion(motion);
	}

// Now: 

	int x,y;
	x = motion->x;
	y = motion->y;

	x += my_moveDelta.x;
	y += my_moveDelta.y;

	if(GetParent() != NULL) {  // Not a top-level-widget
		PG_Point pos = GetParent()->ScreenToClient(x,y);
		x = pos.x;
		y = pos.y;         // Should not be moved out of the parent:
		if(x >= GetParent()->Width() - 5) x = GetParent()->Width() - 5;
		if(y >= GetParent()->Height() - 5) y = GetParent()->Height() - 5;
	}
	else {                     // A top-level-widget
		if(x > (my_srfScreen->w - my_width - 1)) x = (my_srfScreen->w - my_width - 1);
		if(y > (my_srfScreen->h - my_height - 1)) y = (my_srfScreen->h - my_height - 1);	
	}

	if(x < 0) x=0;
	if(y < 0) y=0;

// Old:

//	if(x < 0) x=0;
//	if(y < 0) y=0;
//	if(x > (my_srfScreen->w - my_width - 1)) x = (my_srfScreen->w - my_width -1);
//	if(y > (my_srfScreen->h - my_height - 1)) y = (my_srfScreen->h - my_height -1);

	MoveWindow(x,y);
	return true;
}

bool PG_Window::eventButtonClick(int id, PG_Widget* widget) {
	// close window
	if(id == PG_WINDOW_CLOSE) {
		Hide(true);
		SendMessage(NULL, MSG_WINDOWCLOSE, GetID(), 0);
		return true;
	}

	return false;
}

void PG_Window::SetColorTitlebar(Uint32 color) {
	my_colorTitlebar.r = (color >> 16) & 0xFF;
	my_colorTitlebar.g = (color >> 8)  & 0xFF;
	my_colorTitlebar.b = color & 0xFF;

	my_labelTitle->SetTextColor(my_colorTitlebar);
}
