/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/09 18:28:12 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pgstaticframe.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.22 $
    Status:           $State: Exp $
*/

#include "pgstaticframe.h"
#include "pgapplication.h"

PG_StaticFrame::PG_StaticFrame(PG_Widget* parent, const PG_Rect& r, const char* style) :
PG_GradientWidget(parent, r, false)
{
	my_image = NULL;
	my_freeimage = false;
	my_simplebackground = false;
	my_nocache = false;

	my_backgroundcolor.r = 128;
	my_backgroundcolor.g = 128;
	my_backgroundcolor.b = 128;

	my_cachesurface = NULL;

	LoadThemeStyle("GradientWidget", "GradientWidget");
	LoadThemeStyle(style);
}

PG_StaticFrame::~PG_StaticFrame() {
	FreeImage();
	DeleteThemedSurface(my_cachesurface);
}

void PG_StaticFrame::LoadThemeStyle(const char* widgettype) {
	LoadThemeStyle(widgettype, "GradientWidget");
}

void PG_StaticFrame::LoadThemeStyle(const char* widgettype, const char* objectname) {
	PG_Theme* t = PG_Application::GetTheme();

	PG_GradientWidget::LoadThemeStyle(widgettype, objectname);

	int b = t->FindProperty(widgettype, objectname, "simplebackground");
	my_simplebackground = (b != -1) ? b : my_simplebackground;

	b = t->FindProperty(widgettype, objectname, "nocache");
	my_nocache = (b != -1) ? b : my_nocache;

	SDL_Color* c = t->FindColor(widgettype, objectname, "backgroundcolor");
	if(c != NULL) {
		my_backgroundcolor = *c;
	}

	if(!my_simplebackground && !my_nocache) {
		DeleteThemedSurface(my_cachesurface);
		my_cachesurface = CreateThemedSurface(
						*this,
						&my_gradient,
						my_background,
						my_backgroundMode,
						my_blendLevel);
	}
}

void PG_StaticFrame::FreeImage() {

	if(my_freeimage && (my_image != NULL)) {
		SDL_FreeSurface(my_image);
	}

	my_freeimage = false;
	my_image = NULL;

	return;
}

void PG_StaticFrame::SetBackground(SDL_Surface* image) {
	if(image == NULL) {
		return;
	}

	FreeImage();

	my_image = image;
	my_freeimage = false;
}

/**  */
bool PG_StaticFrame::LoadBackground(const char* filename) {

	FreeImage();

	my_image = PG_LoadImage(PG_Application::GetRelativePath((char*)filename));
	my_freeimage = true;

	if(my_image == NULL)
		return false;

	Update();

	return true;
}

void PG_StaticFrame::eventSizeWindow(int w, int h) {

	if((w == Width()) && (h == Height())) {
		return;
	}

	if(!my_simplebackground) {
		DeleteThemedSurface(my_cachesurface);

		PG_Rect r(my_xpos, my_ypos, w, h);

		my_cachesurface = CreateThemedSurface(
						r,
						&my_gradient,
						my_background,
						my_backgroundMode,
						my_blendLevel);
	}
}

void PG_StaticFrame::eventDraw(SDL_Surface* surface, const PG_Rect& rect) {
}

void PG_StaticFrame::eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst) {

	if(!my_simplebackground && !my_nocache) {
		if(my_cachesurface != NULL) {
			PG_DrawObject::eventBlit(my_cachesurface, src, dst);
		}
	}
	else if (my_simplebackground){
		if(my_transparency < 255) {
			Uint32 c = SDL_MapRGBA(
									my_srfScreen->format,
									my_backgroundcolor.r,
									my_backgroundcolor.g,
									my_backgroundcolor.b,
									255-my_transparency);
		    SDL_FillRect(my_srfScreen, (SDL_Rect*)&dst, c);
		}
	}
	else if (my_nocache) {
		my_cachesurface = CreateThemedSurface(
						*this,
						&my_gradient,
						my_background,
						my_backgroundMode,
						my_blendLevel);
		PG_DrawObject::eventBlit(my_cachesurface, src, dst);
		DeleteThemedSurface(my_cachesurface);
		my_cachesurface = NULL;
	}
	
	if(my_bordersize > 0) {
		DrawBorder(PG_Rect(0, 0, Width(), Height()), my_bordersize, true);
	}

	if(my_image != NULL) {
		PG_Rect my_src;
		PG_Rect my_dst;

		GetClipRects(my_src, my_dst, *this);
		PG_DrawObject::eventBlit(my_image, my_src, my_dst);
	}
}

void PG_StaticFrame::SetTransparency(Uint8 t) {
	if(my_simplebackground || my_nocache) {
		PG_DrawObject::SetTransparency(t);
		return;
	}

	if(t == 255) {
		DeleteThemedSurface(my_cachesurface);
		my_cachesurface = NULL;
	}
	else if(my_transparency == 255) {
		DeleteThemedSurface(my_cachesurface);
		my_cachesurface = CreateThemedSurface(
						*this,
						&my_gradient,
						my_background,
						my_backgroundMode,
						my_blendLevel);
	}
	PG_DrawObject::SetTransparency(t);
}

