/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/22 09:34:40 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/src/Attic/pgcolumnitem.cpp,v $
    CVS/RCS Revision: $Revision: 1.1.2.10 $
    Status:           $State: Exp $
*/

#include "pgcolumnitem.h"

PG_ColumnItem::PG_ColumnItem(int columns, int height, void* userdata) : PG_ListBoxItem(height) {
	SetUserData(userdata);
	my_columncount = columns;

	// fill our vectors with the default values
	for(int i=0; i<my_columncount; i++) {
		my_columnwidth.push_back(Width()/my_columncount);
		my_columntext.push_back("");
	}

}

PG_ColumnItem::~PG_ColumnItem() {
	my_columnwidth.clear();
	my_columntext.clear();
}

void PG_ColumnItem::SetColumnWidth(int column, int width) {
	my_columnwidth[column] = width;
}

void PG_ColumnItem::SetColumnText(int column, char* text) {
	my_columntext[column] = text;
	Redraw();
}
	
void PG_ColumnItem::eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst) {
	int xshift = 0;

	if((dst.my_width == 0) || (dst.my_height == 0)) {
		return;
	}

	PG_ListBoxItem::eventBlit(srf, src, dst);

	if(my_srfIcon != NULL) {
		xshift = my_srfIcon->w;
	}

	for(int i=0; i<my_columncount; i++) {

		if(my_columntext[i].empty()) {
			xshift += my_columnwidth[i];
			continue;
		}

		int w,h;
		GetTextExtend(my_columntext[i].c_str(), w, h);
		DrawText(xshift, (my_itemheight - h) / 2, my_columntext[i].c_str(), GetTextColor(), GetFont());

		xshift += my_columnwidth[i];
	}

}

int PG_ColumnItem::GetColumnWidth(int column) {
	return my_columnwidth[column];
}

const char* PG_ColumnItem::GetColumnText(int column) {
	return my_columntext[column].c_str();
}

int PG_ColumnItem::GetColumnCount() {
	return my_columncount;
}
