/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __NNTP_H__
#define __NNTP_H__

#include <glib.h>

#include <pan/base/article.h>
#include <pan/base/group.h>
#include <pan/base/server.h>
#include <pan/base/status-item.h>

#include <pan/sockets.h>

enum
{
	NNTP_VERBOSE_TEXT		= 1<<0,
	NNTP_VERBOSE_INIT_STEPS		= 1<<1,
	NNTP_VERBOSE_NEXT_STEP		= 1<<2,
	NNTP_VERBOSE			= ~0
};

gint    nntp_command              (StatusItem           * status,
                                   PanSocket            * sock,
                                   const gchar         ** setme_result,
                                   const gchar          * command);
 
gint    nntp_command_va           (StatusItem           * status,
                                   PanSocket            * sock,
                                   const gchar         ** setme_result,
                                   const gchar          * command_va,
                                   ...);

gint    nntp_handshake            (StatusItem           * status,
                                   PanSocket            * socket,
                                   gboolean             * setme_posting_ok);

gint    nntp_authenticate         (StatusItem           * status,
                                   PanSocket            * socket);

gint    nntp_authenticate_types   (StatusItem           * status,
                                   PanSocket            * socket,
                                   gboolean              check_auth_types);

gint    nntp_disconnect           (StatusItem           * status,
                                   PanSocket            * socket);

gint    nntp_noop                 (StatusItem           * status,
                                   PanSocket            * socket);

gint    nntp_set_group            (StatusItem           * status,
                                   PanSocket            * socket,
                                   const char           * groupname);

gint    nntp_can_post             (StatusItem           * status,
                                   PanSocket            * sock,
                                   gboolean             * setme_can_post);

gint    nntp_post                 (StatusItem           * status,
                                   PanSocket            * socket,
                                   const char           * message);

gint    nntp_get_group_info       (StatusItem           * status,
                                   PanSocket            * sock,
                                   const char           * group_name,
                                   gulong               * setme_article_qty,
                                   gulong               * setme_low_num,
                                   gulong               * setme_high_num,
                                   const gboolean       * abort);

gint    nntp_article_download_to_gstr    (StatusItem           * status,
                                           PanSocket            * sock,
                                           Group                * group,
                                           Article              * article,
                                           const gboolean       * abort_download,
			                   gint                   nntp_verbosity,
			                   gboolean               checkout,
			                   GString              * setme);

gint    nntp_article_download     (StatusItem           * status,
                                   PanSocket            * sock,
                                   Group                * group,
                                   Article              * article,
                                   const gboolean       * abort_download,
			           gint                   nntp_verbosity,
			           gboolean               checkout);

/**
 * This will try to get headers for articles [low-high] from the specified
 * server/group and store them as Article objects in the setme array.
 *
 * If verbose is true and the operation is successful,  the StatusItem will
 * emit low-high status_item_next_step signals.
 */
gint nntp_download_headers (StatusItem       * item,
                            PanSocket        * sock,
                            Group            * group,
                            gulong             low,
                            gulong             high,
                            const gboolean   * abort,
			    const char       * progress_fmt,
                            GPtrArray        * setme);

/**
 * emits articles->len status_item_next_step signals.
 */
gint nntp_download_bodies (StatusItem        * item,
                           Group             * group,
                           PanSocket         * sock,
                           const gboolean    * abort,
                           const GPtrArray   * const articles,
                           gint              * index,
                           gboolean            checkout,
                           gboolean            abort_if_one_fails);

gint nntp_cancel (StatusItem            * item,
                  const Article         * article,
                  PanSocket             * sock);

#endif /* __NNTP_H__ */
