/*
 * Pan - A Newsreader for X
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * dialog-about.c: About dialog
 */

#include <config.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <pan/base/pan-i18n.h>
#include <pan/dialogs/dialogs.h>
#include <pan/dialogs/pan-about.h>

static char * get_credits_code (void);
static char * get_credits_users (void);
static char * get_credits_translators (void);

/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	char * pch;
	char * credits_bugs;
	char * credits_i18n;
	char * credits_code;
	GtkWidget * about;

	about = pan_about_new (GTK_WINDOW(window),
	                       "Pan", VERSION,
	                       _("A newsreader for GNOME"),
	                       _("Copyright (C) 2002 Charles Kerr"),
	                       PAN_ABOUT_LICENSE_GPL,
	                       "http://pan.rebelbase.com/");

	pan_about_add_author (about, "Charles Kerr", "charles@rebelbase.com",
	                      _("Programmer"));
	pan_about_add_author (about, "Christophe Lambin", "clambin@easynet.be",
	                      _("Programmer"));
	pan_about_add_author (about, "Adam Huffman", "bloch@verdurin.com",
	                      _("Programmer & Documentation"));
	pan_about_add_author (about, "Matt Eagleson", "e.Messiah@superpimp.org",
	                      _("Project Originator, Programmer"));
	pan_about_add_author (about, "Jason Leach", "jleach@ximian.com",
	                      _("Programmer, 0.6 - 0.7"));

	credits_i18n = get_credits_translators ();
	credits_code = get_credits_code ();
	credits_bugs = get_credits_users ();
	pch = g_strdup_printf (_("Many thanks to the following people, whose contributions\n"
	                         "are a large part of why Open Source software development\n"
	                         "is so fun.\n"
                                 "\n"
                                 "Pan %s Translations\n%s\n"
                                 "\n"
                                 "Pan %s Code or Patches\n%s\n"
                                 "\n"
                                 "Pan %s Suggestions and Testing\n%s\n"
                                 "\n"
                                 "If you should have been in this list but you're not,\n"
                                 "send us mail and we'll add you next time.\n"
                                 "\n"
	                         "Contributors to previous versions are listed at\n"
	                         "http://pan.rebelbase.com/CREDITS"),
	                         VERSION, credits_i18n,
	                         VERSION, credits_code,
	                         VERSION, credits_bugs);
	pan_about_add_text (about, _("Thanks"), pch);
	g_free (credits_i18n);
	g_free (credits_code);
	g_free (credits_bugs);
	g_free (pch);

	gtk_widget_show (about);
}


static char *
get_credits_translators (void)
{
	return g_strdup (
"\n\tCatalan - Quico Llach"
"\n\tChinese - zipeco"
"\n\tDanish - Gitte Wange"
"\n\tDutch - Almer S. Tigelaar"
"\n\tGerman - Christian Meyer"
"\n\tGreek - Simos Xenitellis"
"\n\tEnglish (British) - Robert Brady"
"\n\tSpanish - Antonio de la Torre"
"\n\tEstonian - Tivo Leedjrv"
"\n\tFinnish - Jarmo Kielosto"
"\n\tFrench - Christophe Merlet"
"\n\tGalician - Jess Bravo lvarez"
"\n\tHungarian - Andras Timar"
"\n\tIrish - Alastair McKinstry"
"\n\tItalian - Francesco Lamonica"
"\n\tJapanese - Takeshi Aihana"
"\n\tKorean - Nam SungHyun"
"\n\tLithuanian - Gediminas Paulauskas"
"\n\tNorwegian - Tov Are Jacobsen"
"\n\tPolish - GNOME PL Team"
"\n\tPortuguese - Duarte Loreto"
"\n\tBrazilian Portuguese - Juan Carlos Castro y Castro"
"\n\tRussian - Valek Filippov"
"\n\tSlovak - Marcel Telka"
"\n\tSlovenian - Andraz Tori"
"\n\tSerbian - Zoltan ala"
"\n\tSwedish - Christian Rose"
"\n\tTurkish - Grkem etin"
"\n\tUkranian - Yuri Syrota"
"\n\tVietnamese - pclouds");
}

static char *
get_credits_code (void)
{
	return g_strdup (
"\n\tColon Leroy"
"\n\tTivo Leedjrv"
"\n\tSam Solon");
}

static char *
get_credits_users (void)
{
	return g_strdup (
"\n\tNerijus Baliunas   (#65513)"
"\n\tPierre Beaumadier (#86203)"
"\n\tAdam Bloch   (#83229, #80275, #81452, #76067)"
"\n\tBrian   (#76350, #80901)"
"\n\tArtur Brodowski   (#65161)"
"\n\tJuan Carlos Castro y Castro   (#68058)"
"\n\tchaton.jm   (#78112)"
"\n\tFrederic Crozat   (#84991)"
"\n\tGabi Davar (#85445)"
"\n\tGeorg Drees   (#81258)"
"\n\tBernard DEBREIL   (#81464)"
"\n\tAnne Fairchild   (#84270)"
"\n\tFred Fraley (#86409)"
"\n\tFred   (#71108)"
"\n\tFrobnoid   (#72091)"
"\n\tThomas Gamble   (#80715, #82157, #84543)"
"\n\tEmmanuel Gravel   (#79263)"
"\n\tJames Green   (#82993)"
"\n\tHimanshu J. Gohel   (#64867, #74891)"
"\n\tDan Hensley   (#78557, #78552)"
"\n\tMax Horn"
"\n\tCarl Hudkins (#84620, #85510, #85725, #86795)"
"\n\tLuis M. Ibarra   (#85028)"
"\n\tToby Inkster   (#81278)"
"\n\tJean-Marc (#85968)"
"\n\tKang Jeong-Hee (#74885, #75478, #76110, #78158, #76484, #74866, #74867, #75182, #76217, #80002)"
"\n\tTed Kaczmarek   (#72077, #81815)"
"\n\tCharles Kerr   (#80739, #79338)"
"\n\tChristophe Lambin   (#79377)"
"\n\tPhilip Langdale   (#79669, #85140)"
"\n\tJohn Le May Jr.   (#82828)"
"\n\tGregory Leblanc   (#79811)"
"\n\tTivo Leedjrv   (#76221)"
"\n\tKing Leo   (#80470)"
"\n\tColin Leroy   (#83271)"
"\n\tLarry Levesque   (#67554)"
"\n\tD.m.D. Ljungmark (#87518)"
"\n\tAdam M.   (#72435)"
"\n\tWilliam Maddler (#81181)"
"\n\tWilliam McBrine   (#75136)"
"\n\tAndrew Morgan   (#76103)"
"\n\tmdew   (#79318)"
"\n\tRoman Moller   (#81726, #84056)"
"\n\tEmil Obermayr   (#82724)"
"\n\tAlan Olsen   (#81804)"
"\n\tGianpaolo Racca   (#79839)"
"\n\tVille Ranki   (#69390)"
"\n\tNeural Revenge   (#53465)"
"\n\tMike Roark   (#77571)"
"\n\tCorey Rogers"
"\n\tJoshua Rosen   (#72536)"
"\n\tJorge Salinas   (#65511, #65512)"
"\n\tAasmund Skjaeveland   (#80177, #83157))"
"\n\tSi (#72555)"
"\n\tAlexander Skwar (#85502, #85503, #85508)"
"\n\tJason Sperber   (#84543)"
"\n\tT'aZ   (#81950, #77698)"
"\n\tMarcel Telka"
"\n\tMartin Tomasek (#83271, #84985, #84987, #84995, #85082)"
"\n\tketil V.   (#79221)"
"\n\tFrank Van Damme   (#79275, #83045))"
"\n\tFrederik Vanrenterghem   (#82901)"
"\n\tAlen Williams   (#79873)"
"\n\tWilliam Wu   (#81868) ");
}
