/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __UTIL_IO_H__
#define __UTIL__IOH__

#include <stdio.h>
#include <time.h>

#include <glib.h>

char* pan_make_temp (FILE **);

/**
 * Returns the number of bytes in the file, or 0 on error.
 * @return the number of bytes in the file, or 0 on error.
 * @param filename
 */
size_t get_filesize (const char* filename);

/**
 * Checks to make sure the directory exists.  If it doesn't, directory_check()
 * tries to create it.  If its parent directories don't exist either,
 * directory_check() tries to create them first.
 *
 * @param pathname
 */
gboolean directory_check (const char* pathname);


int change_file_mode_rw (FILE * fp, const char * file);

gboolean file_exists (const char  * filename);

char* pan_normalize_filename_inplace (char * filename);

const char*
mbox_get_next_message (const char * buf,
                       char ** setme_from,
                       GString * setme_msg);

char*
mbox_format_message (const char * message,
                     const char * author_addr,
                     time_t date);

gboolean
pan_rename (const char * old_filename,
            const char * new_filename);

#endif /* __UTIL_H__ */

