/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARGSET_H__
#define __ARGSET_H__

#include <glib.h>

typedef struct
{
	GPtrArray * args;
}
ArgSet;

ArgSet * argset_new (void);
ArgSet * argset_new1 (gpointer);
ArgSet * argset_new2 (gpointer, gpointer);
ArgSet * argset_new3 (gpointer, gpointer, gpointer);
ArgSet * argset_new4 (gpointer, gpointer, gpointer, gpointer);
ArgSet * argset_new5 (gpointer, gpointer, gpointer, gpointer, gpointer);
ArgSet * argset_new6 (gpointer, gpointer, gpointer, gpointer, gpointer, gpointer);

gpointer argset_get (ArgSet*, gint index);
void argset_add (ArgSet*, gpointer);
void argset_free (ArgSet*);

typedef void *(*WorkerFunc)(void*);
void run_in_worker_thread (WorkerFunc, gpointer);


#endif
