/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@rebelbase.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ACACHE_H__
#define __ACACHE_H__

#include <stdio.h>
#include <glib.h>
#include <pan/base/pan-callback.h>

void       acache_init              (void);

void       acache_shutdown          (void);

int        acache_expire            (void);

int        acache_expire_all        (void);

void       acache_expire_messages   (const char   ** message_id,
                                     int             message_id_qty);

void       acache_file_checkin      (const char   ** message_id,
                                     int             message_id_qty);

void       acache_file_checkout     (const char   ** message_ids,
                                     int             message_id_qty);

void       acache_file_checkout_fps (const char   ** message_ids,
                                     int             message_id_qty,
                                     FILE        *** fps_allocme);

gboolean   acache_has_message       (const char    * message_id);

char*      acache_get_message       (const char    * message_id,
                                     gboolean        need_zero_termination);

void       acache_set_message       (const char    * message_id,
                                     const char    * message,
                                     guint           message_len,
                                     gboolean        checkout,
                                     const char    * default_charset);


extern PanCallback* acache_bodies_added_callback;
 
extern PanCallback* acache_bodies_removed_callback;


#endif /* __ACACHE_H__ */
