#include <limits.h>
#include <glib.h>

#include <pan/base/acache.h>
#include <pan/base/pan-i18n.h>
#include <pan/base/pan-glib-extensions.h>
#include <pan/base/base-prefs.h>
#include <pan/base/util-file.h>

char * download_dir = NULL;
char * default_incoming_name_real;
char * default_incoming_name_addr;
int acache_max_megs = 10;
gboolean acache_flush_on_exit = FALSE;
gboolean break_thread_when_subject_changes = FALSE;

static gboolean _quote_chars_impl[UCHAR_MAX];
const gboolean * const _quote_chars = _quote_chars_impl;

void
base_prefs_init (const char    * new_download_dir,
                 const char    * new_quote_chars,
                 int             new_acache_max_megs,
                 gboolean        new_acache_flush_on_exit,
                 gboolean        break_thread)
{
	int i;

	replace_gstr (&download_dir, g_strdup(new_download_dir));
	break_thread_when_subject_changes = break_thread;

	acache_max_megs = new_acache_max_megs;
	acache_flush_on_exit = new_acache_flush_on_exit;
	acache_init ();

	default_incoming_name_real = _("Unknown");
	default_incoming_name_addr = _("unknown@spammesenseless.net");

	/* set _quote_chars */
	for (i=0; i<UCHAR_MAX; ++i)
		_quote_chars_impl[i] = FALSE;
	for (i=0; new_quote_chars!=NULL && new_quote_chars[i]!='\0'; ++i)
		_quote_chars_impl[(guchar)new_quote_chars[i]] = TRUE;
}

const char*
get_data_dir (void)
{
	static char * path = NULL;

	if (path == NULL)
	{
		const char * pan_home = g_getenv ("PAN_HOME");

		if (path==NULL && is_nonempty_string (pan_home))
			path = g_strdup (pan_home);

		if (path==NULL) {
			path = g_strdup_printf ("%s%c.pan%cdata", g_get_home_dir (), G_DIR_SEPARATOR, G_DIR_SEPARATOR);
			if (!g_file_test (path, G_FILE_TEST_IS_DIR))
				replace_gstr (&path, NULL);
		}

		if (path==NULL)
			path = g_strdup_printf ("%s/.pan", g_get_home_dir());

		directory_check (path);
	}

	return path;
}
