%% Generated by the Erlang ASN.1 BER_V2-compiler version, utilizing bit-syntax:1.4.5
%% Purpose: encoder and decoder to the types in mod OrberCSIv2

-module('OrberCSIv2').
-include("OrberCSIv2.hrl").
-define('RT_BER',asn1rt_ber_bin_v2).
-asn1_info([{vsn,'1.4.5'},
            {module,'OrberCSIv2'},
            {options,[ber_bin_v2,{d,'ORBVSN',[51,46,54,46,54]},report_errors,{cwd,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,111,114,98,101,114,47,115,114,99]},{outdir,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,111,114,98,101,114,47,115,114,99]},{i,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,111,114,98,101,114,47,105,110,99,108,117,100,101]},{i,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,115,115,108,47,112,107,105,120]},noobj,optimize,compact_bit_string,der,{attribute,insert,app_vsn,[111,114,98,101,114,95,51,46,54,46,54]},{parse_transform,sys_pre_attributes},debug_info,{i,[46]},{i,[47,108,100,105,115,107,47,100,97,105,108,121,95,98,117,105,108,100,47,111,116,112,95,112,114,101,98,117,105,108,100,95,114,49,49,98,46,50,48,48,55,45,48,54,45,49,49,95,49,57,47,111,116,112,95,115,114,99,95,82,49,49,66,45,53,47,108,105,98,47,111,114,98,101,114,47,115,114,99]}]}]).

-export([encoding_rule/0]).
-export([
'enc_VerifyingCertChain'/2,
'enc_AttributeCertChain'/2,
'enc_CertificateChain'/2
]).

-export([
'dec_VerifyingCertChain'/2,
'dec_AttributeCertChain'/2,
'dec_CertificateChain'/2
]).

-export([
'gssup-mechanism'/0,
'scoped-username'/0
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   ber_bin_v2.

encode(Type,Data) ->
case catch encode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,Bytes};
  Bytes ->
    {ok,Bytes}
end.

decode(Type,Data) ->
case catch decode_disp(Type,element(1,?RT_BER:decode(Data))
) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  Result ->
    {ok,Result}
end.

encode_disp('VerifyingCertChain',Data) -> 'enc_VerifyingCertChain'(Data);
encode_disp('AttributeCertChain',Data) -> 'enc_AttributeCertChain'(Data);
encode_disp('CertificateChain',Data) -> 'enc_CertificateChain'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('VerifyingCertChain',Data) -> 'dec_VerifyingCertChain'(Data);
decode_disp('AttributeCertChain',Data) -> 'dec_AttributeCertChain'(Data);
decode_disp('CertificateChain',Data) -> 'dec_CertificateChain'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).





info() ->
   case ?MODULE:module_info() of
      MI when is_list(MI) ->
         case lists:keysearch(attributes,1,MI) of
            {value,{_,Attributes}} when is_list(Attributes) ->
               case lists:keysearch(asn1_info,1,Attributes) of
                  {value,{_,Info}} when is_list(Info) ->
                     Info;
                  _ ->
                     []
               end;
            _ ->
               []
         end
   end.


%%================================
%%  VerifyingCertChain
%%================================
'enc_VerifyingCertChain'(Val) ->
    'enc_VerifyingCertChain'(Val, [<<48>>]).


'enc_VerifyingCertChain'({'VerifyingCertChain',Val}, TagIn) ->
   'enc_VerifyingCertChain'(Val, TagIn);

'enc_VerifyingCertChain'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_VerifyingCertChain_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_VerifyingCertChain_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_VerifyingCertChain_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit88':'enc_Certificate'(H, [<<48>>]),
   'enc_VerifyingCertChain_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_VerifyingCertChain'(Tlv) ->
   'dec_VerifyingCertChain'(Tlv, [16]).

'dec_VerifyingCertChain'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['PKIX1Explicit88':'dec_Certificate'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  AttributeCertChain
%%================================
'enc_AttributeCertChain'(Val) ->
    'enc_AttributeCertChain'(Val, [<<48>>]).

'enc_AttributeCertChain'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute attributeCert(1)   External PKIXAttributeCertificate:AttributeCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIXAttributeCertificate':'enc_AttributeCertificate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute certificateChain(2)   External OrberCSIv2:VerifyingCertChain
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_VerifyingCertChain'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AttributeCertChain'(Tlv) ->
   'dec_AttributeCertChain'(Tlv, [16]).

'dec_AttributeCertChain'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute attributeCert(1)   External PKIXAttributeCertificate:AttributeCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIXAttributeCertificate':'dec_AttributeCertificate'(V1, [16]),

%%-------------------------------------------------
%% attribute certificateChain(2)   External OrberCSIv2:VerifyingCertChain
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_VerifyingCertChain'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AttributeCertChain', Term1, Term2}.



%%================================
%%  CertificateChain
%%================================
'enc_CertificateChain'(Val) ->
    'enc_CertificateChain'(Val, [<<48>>]).


'enc_CertificateChain'({'CertificateChain',Val}, TagIn) ->
   'enc_CertificateChain'(Val, TagIn);

'enc_CertificateChain'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertificateChain_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificateChain_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertificateChain_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit88':'enc_Certificate'(H, [<<48>>]),
   'enc_CertificateChain_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_CertificateChain'(Tlv) ->
   'dec_CertificateChain'(Tlv, [16]).

'dec_CertificateChain'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['PKIX1Explicit88':'dec_Certificate'(V1, [16]) || V1 <- Tlv1].


'gssup-mechanism'() ->
{2,23,130,1,1,1}.

'scoped-username'() ->
{2,23,130,1,2,1}.

